/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.gamestate;

import com.crihexe.gamestate.GameState;
import com.crihexe.gamestate.States;
import com.crihexe.gamestate.states.FourByFour;
import com.crihexe.gamestate.states.GameOver;
import com.crihexe.gamestate.states.Menu;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;

public class GameStateManager {
    public GameState[] states;
    public int currentState;
    private Object[] nullFinalize = new Object[]{"null"};
    public static int numGameStates;

    public GameStateManager() {
        numGameStates = States.values().length;
        this.states = new GameState[numGameStates];
        this.currentState = States.Menu.getValue();
        this.states[States.Menu.getValue()] = new Menu(this);
        if (this.currentState == 743932) {
            System.exit(0);
        }
    }

    public void setState(States state) {
        this.unloadState(this.currentState);
        this.currentState = state.getValue();
        this.loadState(state);
    }

    private void loadState(States state) {
        if (state == States.Menu) {
            this.states[state.getValue()] = new Menu(this);
            this.currentState = state.getValue();
        }
        if (state == States.FourByFour) {
            this.states[state.getValue()] = new FourByFour(this);
            this.currentState = state.getValue();
        }
        if (state == States.GameOver) {
            this.states[state.getValue()] = new GameOver(this);
            this.currentState = state.getValue();
        }
    }

    private void unloadState(int state) {
        this.states[state] = null;
    }

    public void update() {
        try {
            this.states[this.currentState].update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void draw(Graphics2D g) {
        try {
            this.states[this.currentState].draw(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(KeyEvent e) {
        try {
            this.states[this.currentState].keyPressed(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyReleased(KeyEvent e) {
        try {
            this.states[this.currentState].keyReleased(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

