/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.gamestate.states;

import com.crihexe.entities.objects.Cell;
import com.crihexe.entities.objects.Direction;
import com.crihexe.gamestate.GameState;
import com.crihexe.gamestate.GameStateManager;
import com.crihexe.gamestate.States;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.imageio.ImageIO;

public class FourByFour
extends GameState {
    private BufferedImage grid;
    private BufferedImage zero;
    private BufferedImage two;
    private BufferedImage four;
    private BufferedImage eight;
    private BufferedImage st;
    private BufferedImage tt;
    private BufferedImage sf;
    private BufferedImage ote;
    private BufferedImage tfs;
    private BufferedImage ft;
    private BufferedImage otf;
    private BufferedImage tfe;
    private Cell[][] table;
    private int points;
    private Random rand;
    private boolean isTranslated = false;
    private GameStateManager gsm;

    public FourByFour(GameStateManager gsm) {
        super(gsm);
        this.gsm = gsm;
    }

    @Override
    public void init() {
        this.table = new Cell[4][4];
        this.rand = new Random();
        try {
            this.loadImages();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.buildDefaultTable();
    }

    @Override
    protected void update() {
    }

    private int checkMove() {
        int j;
        int moves = 0;
        int i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                System.out.println("i: " + i + "; j: " + j + "; moves: " + moves + " - casella: " + this.table[i][j].getValue());
                if (this.table[i][j].getValue() == 0) {
                    ++moves;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 3) {
                if (this.table[i][j].getValue() == this.table[i][j + 1].getValue()) {
                    ++moves;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 4) {
                if (this.table[i][j].getValue() == this.table[i + 1][j].getValue()) {
                    ++moves;
                }
                ++j;
            }
            ++i;
        }
        return moves;
    }

    private void loadImages() throws Exception {
        this.grid = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/grid.png"));
        this.zero = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/void.png"));
        this.two = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/two.png"));
        this.four = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/four.png"));
        this.eight = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/eight.png"));
        this.st = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/sixteen.png"));
        this.tt = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/thirtytwo.png"));
        this.sf = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/sixtyfour.png"));
        this.ote = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/onehundred-twentyeight.png"));
        this.tfs = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/twohundred-fiftysix.png"));
        this.ft = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/fivehundred-twelve.png"));
        this.otf = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/onethousand-twentyfour.png"));
        this.tfe = ImageIO.read(this.getClass().getResourceAsStream("/assets/cells/twothousand-fourtyeight.png"));
    }

    private void move(Direction direction) {
        int iOK;
        int jOK;
        int i = 0;
        int j = 0;
        int k = 0;
        if (direction.getDirection() == 1) {
            i = 0;
            while (i < 4) {
                jOK = -1;
                j = 1;
                while (j < 4) {
                    if (this.table[i][j].getValue() == this.table[i][j - 1].getValue() && this.table[i][j].getValue() != 0) {
                        this.points += this.table[i][j].getValue() * 2;
                        this.table[i][j - 1].setValue(this.table[i][j].getValue() * 2);
                        this.table[i][j].setValue(0);
                        jOK = j - 1;
                    } else if (j - 2 >= 0) {
                        if (this.table[i][j].getValue() == this.table[i][j - 2].getValue() && j - 2 >= 0 && this.table[i][j - 1].getValue() == 0 && j - 2 != jOK && this.table[i][j].getValue() != 0) {
                            this.points += this.table[i][j].getValue() * 2;
                            this.table[i][j - 2].setValue(this.table[i][j].getValue() * 2);
                            this.table[i][j].setValue(0);
                            jOK = j - 2;
                        } else if (j - 3 >= 0 && this.table[i][j].getValue() == this.table[i][j - 3].getValue() && j - 3 >= 0 && this.table[i][j - 1].getValue() == 0 && this.table[i][j - 2].getValue() == 0 && j - 2 != jOK && j - 3 != jOK && this.table[i][j].getValue() != 0) {
                            this.points += this.table[i][j].getValue() * 2;
                            this.table[i][j - 3].setValue(this.table[i][j].getValue() * 2);
                            this.table[i][j].setValue(0);
                            jOK = j - 3;
                        }
                    }
                    ++j;
                }
                k = 0;
                while (k < 32) {
                    j = 1;
                    while (j < 4) {
                        if (this.table[i][j - 1].getValue() == 0) {
                            this.table[i][j - 1].setValue(this.table[i][j].getValue());
                            this.table[i][j].setValue(0);
                        } else if (j - 2 >= 0) {
                            if (this.table[i][j - 2].getValue() == 0 && j - 2 >= 0) {
                                this.table[i][j - 2].setValue(this.table[i][j].getValue());
                                this.table[i][j].setValue(0);
                            } else if (j - 3 >= 0 && this.table[i][j - 3].getValue() == 0 && j - 3 >= 0) {
                                this.table[i][j - 3].setValue(this.table[i][j].getValue());
                                this.table[i][j].setValue(0);
                            }
                        }
                        ++j;
                    }
                    ++k;
                }
                ++i;
            }
        } else if (direction.getDirection() == 2) {
            i = 0;
            while (i < 4) {
                jOK = -1;
                j = 2;
                while (j >= 0) {
                    if (this.table[i][j].getValue() == this.table[i][j + 1].getValue() && this.table[i][j].getValue() != 0) {
                        this.points += this.table[i][j].getValue() * 2;
                        this.table[i][j + 1].setValue(this.table[i][j].getValue() * 2);
                        this.table[i][j].setValue(0);
                        jOK = j + 1;
                    } else if (j + 2 < 4) {
                        if (this.table[i][j].getValue() == this.table[i][j + 2].getValue() && j + 2 < 4 && this.table[i][j + 1].getValue() == 0 && j + 2 != jOK && this.table[i][j].getValue() != 0) {
                            this.points += this.table[i][j].getValue() * 2;
                            this.table[i][j + 2].setValue(this.table[i][j].getValue() * 2);
                            this.table[i][j].setValue(0);
                            jOK = j + 2;
                        } else if (j + 3 < 4 && this.table[i][j].getValue() == this.table[i][j + 3].getValue() && j + 3 < 4 && this.table[i][j + 1].getValue() == 0 && this.table[i][j + 2].getValue() == 0 && j + 2 != jOK && j + 3 != jOK && this.table[i][j].getValue() != 0) {
                            this.points += this.table[i][j].getValue() * 2;
                            this.table[i][j + 3].setValue(this.table[i][j].getValue() * 2);
                            this.table[i][j].setValue(0);
                            jOK = j + 3;
                        }
                    }
                    --j;
                }
                k = 0;
                while (k < 32) {
                    j = 2;
                    while (j >= 0) {
                        if (this.table[i][j + 1].getValue() == 0) {
                            this.table[i][j + 1].setValue(this.table[i][j].getValue());
                            this.table[i][j].setValue(0);
                        } else if (j + 2 < 4) {
                            if (this.table[i][j + 2].getValue() == 0 && j + 2 < 4) {
                                this.table[i][j + 2].setValue(this.table[i][j].getValue());
                                this.table[i][j].setValue(0);
                            } else if (j + 3 < 4 && this.table[i][j + 3].getValue() == 0 && j + 3 < 4) {
                                this.table[i][j + 3].setValue(this.table[i][j].getValue());
                                this.table[i][j].setValue(0);
                            }
                        }
                        --j;
                    }
                    ++k;
                }
                ++i;
            }
        } else if (direction.getDirection() == 4) {
            j = 0;
            while (j < 4) {
                iOK = -1;
                i = 1;
                while (i < 4) {
                    if (this.table[i][j].getValue() == this.table[i - 1][j].getValue() && this.table[i][j].getValue() != 0) {
                        this.points += this.table[i][j].getValue() * 2;
                        this.table[i - 1][j].setValue(this.table[i][j].getValue() * 2);
                        this.table[i][j].setValue(0);
                        iOK = i - 1;
                    } else if (i - 2 >= 0) {
                        if (this.table[i][j].getValue() == this.table[i - 2][j].getValue() && i - 2 >= 0 && this.table[i - 1][j].getValue() == 0 && i - 2 != iOK && this.table[i][j].getValue() != 0) {
                            this.points += this.table[i][j].getValue() * 2;
                            this.table[i - 2][j].setValue(this.table[i][j].getValue() * 2);
                            this.table[i][j].setValue(0);
                            iOK = i - 2;
                        } else if (i - 3 >= 0 && this.table[i][j].getValue() == this.table[i - 3][j].getValue() && i - 3 >= 0 && this.table[i - 1][j].getValue() == 0 && this.table[i - 2][j].getValue() == 0 && i - 2 != iOK && i - 3 != iOK && this.table[i][j].getValue() != 0) {
                            this.points += this.table[i][j].getValue() * 2;
                            this.table[i - 3][j].setValue(this.table[i][j].getValue() * 2);
                            this.table[i][j].setValue(0);
                            iOK = i - 3;
                        }
                    }
                    ++i;
                }
                k = 0;
                while (k < 32) {
                    i = 1;
                    while (i < 4) {
                        if (this.table[i - 1][j].getValue() == 0) {
                            this.points += this.table[i][j].getValue() * 2;
                            this.table[i - 1][j].setValue(this.table[i][j].getValue());
                            this.table[i][j].setValue(0);
                        } else if (i - 2 >= 0) {
                            if (this.table[i - 2][j].getValue() == 0 && i - 2 >= 0) {
                                this.points += this.table[i][j].getValue() * 2;
                                this.table[i - 2][j].setValue(this.table[i][j].getValue());
                                this.table[i][j].setValue(0);
                            } else if (i - 3 >= 0 && this.table[i - 3][j].getValue() == 0 && i - 3 >= 0) {
                                this.points += this.table[i][j].getValue() * 2;
                                this.table[i - 3][j].setValue(this.table[i][j].getValue());
                                this.table[i][j].setValue(0);
                            }
                        }
                        ++i;
                    }
                    ++k;
                }
                ++j;
            }
        } else if (direction.getDirection() == 3) {
            j = 0;
            while (j < 4) {
                iOK = -1;
                i = 2;
                while (i >= 0) {
                    if (this.table[i][j].getValue() == this.table[i + 1][j].getValue() && this.table[i][j].getValue() != 0) {
                        this.points += this.table[i][j].getValue() * 2;
                        this.table[i + 1][j].setValue(this.table[i][j].getValue() * 2);
                        this.table[i][j].setValue(0);
                        iOK = i + 1;
                    } else if (i + 2 < 4) {
                        if (this.table[i][j].getValue() == this.table[i + 2][j].getValue() && i + 2 < 4 && this.table[i + 1][j].getValue() == 0 && i + 2 != iOK && this.table[i][j].getValue() != 0) {
                            this.points += this.table[i][j].getValue() * 2;
                            this.table[i + 2][j].setValue(this.table[i][j].getValue() * 2);
                            this.table[i][j].setValue(0);
                            iOK = i + 2;
                        } else if (i + 3 < 4 && this.table[i][j].getValue() == this.table[i + 3][j].getValue() && i + 3 < 4 && this.table[i + 1][j].getValue() == 0 && this.table[i + 2][j].getValue() == 0 && i + 2 != iOK && i + 3 != iOK && this.table[i][j].getValue() != 0) {
                            this.points += this.table[i][j].getValue() * 2;
                            this.table[i + 3][j].setValue(this.table[i][j].getValue() * 2);
                            this.table[i][j].setValue(0);
                            iOK = i + 3;
                        }
                    }
                    --i;
                }
                k = 0;
                while (k < 32) {
                    i = 2;
                    while (i >= 0) {
                        if (this.table[i + 1][j].getValue() == 0) {
                            this.table[i + 1][j].setValue(this.table[i][j].getValue());
                            this.table[i][j].setValue(0);
                        } else if (i + 2 < 4) {
                            if (this.table[i + 2][j].getValue() == 0 && i + 2 < 4) {
                                this.table[i + 2][j].setValue(this.table[i][j].getValue());
                                this.table[i][j].setValue(0);
                            } else if (i + 3 < 4 && this.table[i + 3][j].getValue() == 0 && i + 3 < 4) {
                                this.table[i + 3][j].setValue(this.table[i][j].getValue());
                                this.table[i][j].setValue(0);
                            }
                        }
                        --i;
                    }
                    ++k;
                }
                ++j;
            }
        }
        int genTimes = -10;
        boolean genSuccess = false;
        while (!genSuccess) {
            genSuccess = this.addRandomNumber();
            if (++genTimes > 65536) break;
        }
    }

    private void buildDefaultTable() {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.table[i][j] = new Cell(0);
                ++j;
            }
            ++i;
        }
        this.addRandomNumber();
        this.addRandomNumber();
    }

    private boolean addRandomNumber() {
        int cy;
        int cx = this.rand.nextInt(4);
        if (this.table[cx][cy = this.rand.nextInt(4)].getValue() == 0) {
            boolean high = this.rand.nextBoolean();
            if (high) {
                this.table[cx][cy].setValue(4);
            } else {
                this.table[cx][cy].setValue(2);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void draw(Graphics2D g) {
        g.setFont(new Font("Calibri", 1, 40));
        g.setColor(new Color(68, 68, 68));
        g.fillRect(0, 0, 500, 600);
        g.setColor(Color.white);
        g.drawString("Punti: " + this.points, 50, 50);
        g.drawImage((Image)this.grid, 50, 100, null);
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                if (this.table[i][j].getValue() == 0) {
                    g.drawImage((Image)this.zero, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 2) {
                    g.drawImage((Image)this.two, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 4) {
                    g.drawImage((Image)this.four, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 8) {
                    g.drawImage((Image)this.eight, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 16) {
                    g.drawImage((Image)this.st, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 32) {
                    g.drawImage((Image)this.tt, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 64) {
                    g.drawImage((Image)this.sf, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 128) {
                    g.drawImage((Image)this.ote, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 256) {
                    g.drawImage((Image)this.tfs, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 512) {
                    g.drawImage((Image)this.ft, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 1024) {
                    g.drawImage((Image)this.otf, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                } else if (this.table[i][j].getValue() == 2048) {
                    g.drawImage((Image)this.tfe, 4 * (i + 1) + 90 * i + 50, 4 * (j + 1) + 90 * j + 100, null);
                }
                ++j;
            }
            ++i;
        }
        if (this.checkMove() == 0) {
            this.gsm.setState(States.GameOver);
        }
    }

    @Override
    protected void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            this.move(new Direction(1));
        }
        if (e.getKeyCode() == 40) {
            this.move(new Direction(2));
        }
        if (e.getKeyCode() == 37) {
            this.move(new Direction(4));
        }
        if (e.getKeyCode() == 39) {
            this.move(new Direction(3));
        }
    }

    @Override
    protected void keyReleased(KeyEvent e) {
    }

    @Override
    protected void finalize(Object[] o) {
    }
}

