/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.main;

import com.crihexe.gamestate.GameStateManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener {
    private static final long serialVersionUID = 1L;
    public static final int WIDTH = 500;
    public static final int HEIGHT = 600;
    private static int SCALE = 1;
    private BufferedImage image;
    private Graphics2D g;
    private int FPS = 60;
    private long targetTime = this.FPS / 1000;
    private boolean running;
    private GameStateManager gsm;
    private Thread thread;

    public GamePanel() {
        this.setBackground(new Color(68, 68, 68));
        this.setPreferredSize(new Dimension(500 * SCALE, 600 * SCALE));
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addNotifify();
    }

    private void addNotifify() {
        this.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        this.init();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (this.running) {
            long start = System.nanoTime();
            this.update();
            this.draw();
            this.drawToScreen();
            long elapsed = System.nanoTime() - start;
            long wait = this.targetTime - elapsed / 1000000L;
            if (wait <= 0L) {
                wait = 5L;
            }
            try {
                Thread.sleep(wait);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void init() {
        this.image = new BufferedImage(500, 600, 2);
        this.g = (Graphics2D)this.image.getGraphics();
        this.gsm = new GameStateManager();
        this.running = true;
    }

    private void update() {
        this.gsm.update();
    }

    private void draw() {
        this.gsm.draw(this.g);
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, 500 * SCALE, 600 * SCALE, null);
        g2.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.gsm.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.gsm.keyReleased(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

