/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.entities;

import com.crihexe.main.Main;
import com.crihexe.objects.variables.Direction;
import javax.swing.Timer;

public class Player {
    private double x;
    private double y;
    private double moveSpeed;
    private Direction d = new Direction(2.0);
    private boolean canShoot;
    private Timer timer;

    public Player(double x, double y, double moveSpeed, int shootDelay) {
        this.x = x;
        this.y = y;
        this.moveSpeed = moveSpeed;
        this.canShoot = true;
        this.timer = new Timer(shootDelay, e -> {
            this.canShoot = true;
        });
        this.timer.setRepeats(false);
    }

    public void update() {
        if (this.d.getDirection() == 2.0 && this.x < (double)(Main.getFrameSize().width - 32)) {
            this.x += this.moveSpeed;
        }
        if (this.d.getDirection() == 4.0 && this.x > -16.0) {
            this.x -= this.moveSpeed;
        }
    }

    public void setDirection(Double d) {
        this.d = new Direction(d);
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setCanShoot(boolean canShoot) {
        this.timer.start();
        this.canShoot = canShoot;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean getCanShoot() {
        return this.canShoot;
    }
}

