/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.main;

import com.crihexe.entities.Bullet;
import com.crihexe.entities.Corona;
import com.crihexe.entities.Player;
import com.crihexe.main.Main;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener {
    private static final long serialVersionUID = 1L;
    private Thread thread;
    private boolean running;
    private Random random;
    private int FPS = 120;
    private long targetTime = this.FPS / 1000;
    private Graphics2D g;
    private BufferedImage image;
    private BufferedImage pla;
    private BufferedImage bul;
    private BufferedImage cor;
    private int keyPressed;
    private Player player;
    private ArrayList<Corona> corona;
    private ArrayList<Bullet> bullet;

    public GamePanel() {
        this.setPreferredSize(Main.getFrameSize());
        this.addKeyListener(this);
        this.setFocusable(true);
        this.addNotifify();
    }

    private void addNotifify() {
        super.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        try {
            this.init();
            Thread.sleep(500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (this.running) {
            long start = System.nanoTime();
            this.update();
            this.draw();
            this.drawToScreen();
            long elapsed = System.nanoTime() - start;
            long wait = this.targetTime - elapsed / 1000000L;
            if (wait <= 0L) {
                wait = 5L;
            }
            try {
                Thread.sleep(wait);
            }
            catch (Exception e) {
                System.err.println("Errore in run() di GamePanel.\nErrore in Thread.sleep(wait);\nTrance dell'errore: ");
                e.printStackTrace();
            }
        }
    }

    private void init() throws Exception {
        this.corona = new ArrayList();
        this.bullet = new ArrayList();
        this.random = new Random();
        this.image = new BufferedImage(Main.getFrameSize().width, Main.getFrameSize().height, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.running = true;
        this.pla = ImageIO.read(this.getClass().getResourceAsStream("/assets/ferry.png"));
        this.cor = ImageIO.read(this.getClass().getResourceAsStream("/assets/corona.png"));
        this.bul = ImageIO.read(this.getClass().getResourceAsStream("/assets/bullet.png"));
        this.player = new Player(100.0, 520.0, 1.25, 625);
        this.generateCorona(7);
        Timer timer = new Timer(695, e -> this.generateCorona(1));
        timer.start();
        timer.setRepeats(true);
    }

    private void generateCorona(int times) {
        int i = 0;
        while (i < times) {
            double x = 16.0 + (double)(Main.getFrameSize().width - 32 - 16) * this.random.nextDouble();
            double y = 16.0 + 184.0 * this.random.nextDouble();
            double moveSpeed = 0.15 + 2.6 * this.random.nextDouble();
            boolean right = this.random.nextBoolean();
            double direction = right ? 2.0 : 4.0;
            this.corona.add(new Corona(x, y, moveSpeed, direction));
            ++i;
        }
    }

    private void update() {
        this.checkKeys();
        this.player.update();
        this.updateCorona();
    }

    private void updateBullet() {
        int i = 0;
        while (i < this.bullet.size()) {
            Bullet b = this.bullet.get(i);
            b.update();
            int j = 0;
            while (j < this.corona.size()) {
                Corona c = this.corona.get(j);
                this.checkCollision(b, c, j);
                ++j;
            }
            if (b.getY() < -10.0) {
                b = null;
                this.bullet.remove(i);
            }
            ++i;
        }
    }

    private void checkCollision(Bullet b, Corona c, int h) {
        Rectangle co;
        Rectangle bu = new Rectangle((int)b.getX(), (int)b.getY(), 32, 32);
        if (bu.intersects(co = new Rectangle((int)c.getX(), (int)c.getY(), 32, 32)) || co.intersects(bu)) {
            c = null;
            this.corona.remove(h);
        }
    }

    private void updateCorona() {
        int i = 0;
        while (i < this.corona.size()) {
            this.corona.get(i).update();
            ++i;
        }
    }

    private void checkKeys() {
        if (this.keyPressed == 65) {
            this.player.setDirection(4.0);
        }
        if (this.keyPressed == 68) {
            this.player.setDirection(2.0);
        }
        if (this.keyPressed == 32 && this.player.getCanShoot()) {
            this.bullet.add(new Bullet(this.player.getX(), this.player.getY(), 5.25));
            this.player.setCanShoot(false);
        }
    }

    private void draw() {
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, Main.getFrameSize().width, Main.getFrameSize().height);
        this.g.drawImage((Image)this.pla, (int)this.player.getX(), (int)this.player.getY(), null);
        this.g.setColor(Color.red);
        this.drawCorona();
        this.drawBullet();
        this.updateBullet();
    }

    private void drawCorona() {
        int i = 0;
        while (i < this.corona.size()) {
            this.g.drawImage(this.cor, (int)this.corona.get(i).getX(), (int)this.corona.get(i).getY(), 32, 32, null);
            ++i;
        }
    }

    private void drawBullet() {
        int i = 0;
        while (i < this.bullet.size()) {
            this.g.drawImage(this.bul, (int)this.bullet.get(i).getX(), (int)this.bullet.get(i).getY(), 32, 32, null);
            ++i;
        }
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, null);
        g2.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyPressed = e.getKeyCode();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyPressed = -1;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

