/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.main;

import com.crihexe.main.LifeManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public static final int width = 607;
    public static final int height = 606;
    private int FPS = 60;
    private final long targetTime = this.FPS / 1000;
    private Graphics2D g;
    private BufferedImage image;
    private boolean running;
    private Thread thread;
    private LifeManager lf;
    private int mx;
    private int my;
    private boolean b1 = false;
    private boolean b3 = false;
    private boolean simulationPhase = false;
    private int[][] map = new int[60][60];

    public GamePanel() {
        this.setPreferredSize(new Dimension(607, 606));
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(true);
        this.addNotifify();
    }

    private void addNotifify() {
        this.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        try {
            this.init();
            Thread.sleep(500L);
            while (this.running) {
                long start = System.nanoTime();
                this.update();
                this.draw();
                this.drawToScreen();
                long elapsed = System.nanoTime() - start;
                long wait = this.targetTime - elapsed / 1000000L;
                if (wait <= 0L) {
                    wait = 5L;
                }
                Thread.sleep(wait);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.image = new BufferedImage(607, 606, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.buildDefaultTable();
        this.running = true;
    }

    private void buildDefaultTable() {
        JFrame frame = new JFrame("Comandi");
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JLabel label = new JLabel("Mouse SX: Piazza cellula");
        label.setBounds(10, 10, 1000, 20);
        panel.add(label);
        JLabel label2 = new JLabel("Mouse DX: Distrugge cellula");
        label2.setBounds(10, 25, 1000, 20);
        panel.add(label2);
        JLabel label3 = new JLabel("A: Generazioni automatiche");
        label3.setBounds(10, 40, 1000, 20);
        panel.add(label3);
        JLabel label4 = new JLabel("R: Cancella tutto");
        label4.setBounds(10, 55, 1000, 20);
        panel.add(label4);
        JLabel label5 = new JLabel("Qualsiasi altro tasto:    Genera manualmente");
        label5.setBounds(10, 70, 1000, 20);
        panel.add(label5);
        frame.add(panel);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(2);
        frame.setBounds(700, 100, 300, 150);
        frame.setResizable(false);
        int i = 0;
        while (i < 60) {
            int j = 0;
            while (j < 60) {
                this.map[i][j] = 0;
                ++j;
            }
            ++i;
        }
        this.lf = new LifeManager(this.map, this);
    }

    private void update() {
        if (this.simulationPhase) {
            this.lf.nextGeneration();
        }
        this.map = this.lf.getMap();
    }

    private void draw() {
        this.refresh();
        this.drawTable();
    }

    private void drawTable() {
        this.g.setColor(Color.white);
        int i = 0;
        while (i < 60) {
            int j = 0;
            while (j < 60) {
                if (this.map[i][j] == 1) {
                    this.g.fillRect(10 * i + 1, 10 * j + 1, 9, 9);
                } else if (this.map[i][j] == 2) {
                    this.g.setColor(new Color(255, 255, 0, 200));
                    this.g.fillRect(10 * i + 1, 10 * j + 1, 9, 9);
                    this.g.setColor(Color.white);
                }
                ++j;
            }
            ++i;
        }
    }

    public void updateMap(int[][] map) {
        this.map = map;
    }

    private void refresh() {
        Color c = this.g.getColor();
        this.g.setColor(new Color(31, 31, 31));
        this.g.fillRect(-1214, -1212, 1821, 1818);
        this.g.setColor(Color.darkGray);
        int i = 0;
        while (i < 721) {
            this.g.drawLine(i, 0, i, 606);
            i += 10;
        }
        int j = 0;
        while (j < 721) {
            this.g.drawLine(0, j, 607, j);
            j += 10;
        }
        this.g.setColor(c);
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, 607, 606, null);
        g2.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 82 && e.getKeyCode() != 65) {
            this.lf.nextGeneration();
        } else if (e.getKeyCode() == 82) {
            this.lf.setMap(new int[60][60]);
        } else if (e.getKeyCode() == 65) {
            this.simulationPhase = !this.simulationPhase;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mx = e.getX();
        this.my = e.getY();
        if (this.b1) {
            if (this.mx / 10 >= 0 && this.mx / 10 < 60 && this.my / 10 >= 0 && this.my / 10 < 60) {
                this.map[this.mx / 10][this.my / 10] = 1;
            }
        } else if (this.b3 && this.mx / 10 >= 0 && this.mx / 10 < 60 && this.my / 10 >= 0 && this.my / 10 < 60) {
            this.map[this.mx / 10][this.my / 10] = 0;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mx = e.getX();
        this.my = e.getY();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.b1 = true;
            if (this.mx / 10 >= 0 && this.mx / 10 < 60 && this.my / 10 >= 0 && this.my / 10 < 60) {
                this.map[this.mx / 10][this.my / 10] = 1;
            }
        } else if (e.getButton() == 3) {
            this.b3 = true;
            if (this.mx / 10 >= 0 && this.mx / 10 < 60 && this.my / 10 >= 0 && this.my / 10 < 60) {
                this.map[this.mx / 10][this.my / 10] = 0;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.b1 = false;
        } else if (e.getButton() == 3) {
            this.b3 = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

