package com.crihexe.frames;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import com.crihexe.frames.ClickListener;

public class CButton {
	
	public static final int TYPE_TEXT = 0;
	public static final int TYPE_IMAGE = 1;
	
	public static final int IMAGE_KEEP_SIZE = 10;
	public static final int IMAGE_FILL_RECT = 11;
	
	private String text;
	private BufferedImage image;
	private int x;
	private int y;
	private int w;
	private int h;
	private Color c;
	private int type;
	private Font font;
	private int imageType;
	private boolean borders;
	private Color borderColor;
	private Color textColor;
	private int tx;
	private int ty;
	
	private ClickListener clickListener;
	
	private boolean isHover;
	private boolean isPressed;
	
	public CButton(String text) {
		this.text = text;
		x = 0;
		y = 0;
		w = 100;
		h = 50;
		c = new Color(200, 200, 200);
		textColor = new Color(0);
		type = TYPE_TEXT;
	}
	public CButton(BufferedImage image, int imageType) {
		this.image = image;
		x = 0;
		y = 0;
		w = image.getWidth();
		h = image.getHeight();
		c = new Color(200, 200, 200);
		textColor = new Color(0);
		type = TYPE_IMAGE;
		this.imageType = imageType;
	}
	public CButton(String text, Color c) {
		this.text = text;
		x = 0;
		y = 0;
		w = 100;
		h = 50;
		this.c = c;
		textColor = new Color(0);
		type = TYPE_TEXT;
	}
	public CButton(BufferedImage image, Color c, int imageType) {
		this.image = image;
		x = 0;
		y = 0;
		w = image.getWidth();
		h = image.getHeight();
		this.c = c;
		textColor = new Color(0);
		type = TYPE_IMAGE;
		this.imageType = imageType;
	}
	public CButton(String text, int x, int y, int w, int h) {
		this.text = text;
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
		c = new Color(200, 200, 200);
		textColor = new Color(0);
		type = TYPE_TEXT;
	}
	public CButton(BufferedImage image, int x, int y, int w, int h, int imageType) {
		this.image = image;
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
		c = new Color(200, 200, 200);
		textColor = new Color(0);
		type = TYPE_IMAGE;
		this.imageType = imageType;
	}
	public CButton(String text, int x, int y, int w, int h, Color c) {
		this.text = text;
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
		this.c = c;
		textColor = new Color(0);
		type = TYPE_TEXT;
	}
	public CButton(BufferedImage image, int x, int y, int w, int h, Color c, int imageType) {
		this.image = image;
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
		this.c = c;
		textColor = new Color(0);
		type = TYPE_IMAGE;
		this.imageType = imageType;
	}
	
	public void update(int mx, int my, boolean mouseSX, boolean preMouseSX) {
		mx-=tx;
		my-=ty;
		checkClick(mx, my, mouseSX, preMouseSX);
	}
	public void checkClick(int mx, int my, boolean mouseSX, boolean preMouseSX) {
		if(mx >= x && mx <= x+w && my >= y && my <= y+h) {
			if(!isHover) this.setColor(c.darker());
			isHover = true;
			if(mouseSX) {
				if(!isPressed) this.setColor(c.darker());
				isPressed = true;
			} else {
				if(isPressed) this.setColor(c.brighter());
				isPressed = false;
			}
			if(mouseSX && !preMouseSX && clickListener != null) {
				clickListener.onPress();
			}
			if(!mouseSX && preMouseSX && clickListener != null) {
				clickListener.onRelease();
			}
		} else {
			if(isHover) this.setColor(c.brighter());
			isHover = false;
			if(isPressed) this.setColor(c.brighter());
			isPressed = false;
		}
	}
	public void draw(Graphics2D g) {
		if(font == null) font = g.getFont();
		g.setColor(c);
		g.fillRect(x, y, w, h);
		g.setColor(borderColor);
		g.drawRect(x, y, w, h);
		if(type == TYPE_TEXT) {
			g.setColor(textColor);
			drawCenteredString(g, text, new Rectangle(x, y, w, h), font);
		} else if(type == TYPE_IMAGE) {
			drawCenteredImage(g, image, imageType);
		}
	}
	public void drawCenteredString(Graphics2D g, String text, Rectangle rect, Font font) {
	    FontMetrics metrics = g.getFontMetrics(font);
	    int x = rect.x + (rect.width - metrics.stringWidth(text)) / 2;
	    int y = rect.y + ((rect.height - metrics.getHeight()) / 2) + metrics.getAscent();
	    g.setFont(font);
	    g.drawString(text, x, y);
	}
	public void drawCenteredImage(Graphics2D g, BufferedImage image, int type) {
		if(type == IMAGE_FILL_RECT) {
			g.drawImage(image, x, y, w, h, null);
		} else if(type == IMAGE_KEEP_SIZE) {
			float arI = (float)image.getHeight() / (float)image.getWidth();
			float arB = (float)h / (float)w;
			if(arI > arB) {
				float scale = (float)h / (float)image.getHeight();
				float nw = (float)image.getWidth()*(float)scale;
				float nh = (float)image.getHeight()*(float)scale;
				float ax = ((float)w/(float)2)-((float)nw/(float)2);
				float ay = ((float)h/(float)2)-((float)nh/(float)2);
				g.drawImage(image, (int)ax+x, (int)ay+y+1, (int)nw, (int)nh-1, null);
			} else if(arI == arB) {
				g.drawImage(image, x+1, y+1, w-1, h-1, null);
			} else {
				float scale = (float)w / (float)image.getWidth();
				float nw = (float)image.getWidth()*(float)scale;
				float nh = (float)image.getHeight()*(float)scale;
				float ax = ((float)w/(float)2)-((float)nw/(float)2);
				float ay = ((float)h/(float)2)-((float)nh/(float)2);
				g.drawImage(image, (int)ax+x+1, (int)ay+y, (int)nw-1, (int)nh, null);
			}
		}
	}
	
	public void setX(int x) {
		this.x = x;
	}
	public void setY(int y) {
		this.y = y;
	}
	public void setPosition(int x, int y) {
		this.x = x;
		this.y = y;
	}
	public void setWidth(int w) {
		this.w = w;
	}
	public void setHeight(int h) {
		this.h = h;
	}
	public void setSize(int w, int h) {
		this.w = w;
		this.h = h;
	}
	public void setBounds(int x, int y, int w, int h) {
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
	}
	public void setText(String text) {
		this.text = text;
		type = TYPE_TEXT;
	}
	public void setImage(BufferedImage image, int imageType) {
		this.image = image;
		type = TYPE_IMAGE;
		this.imageType = imageType;
	}
	public void setColor(Color c) {
		this.c = c;
	}
	public void setOnClick(ClickListener cl) {
		this.clickListener = cl;
	}
	public void setFont(Font font) {
		this.font = font;
	}
	public void setImageType(int imageType) {
		this.imageType = imageType;
	}
	public void addBorder(Color borderColor) {
		this.borderColor = borderColor;
		borders = true;
	}
	public void destroyBorder() {
		borders = false;
	}
	public void setForegroundColor(Color textColor) {
		this.textColor = textColor;
	}
	public void setTranslate(int x, int y) {
		tx = x;
		ty = y;
	}
	
	public int getX() {
		return x;
	}
	public int getY() {
		return y;
	}
	public Point getPosition() {
		return new Point(x, y);
	}
	public int getWidth() {
		return w;
	}
	public int getHeight() {
		return h;
	}
	public String getText() {
		return text;
	}
	public BufferedImage getImage() {
		return image;
	}
	public Color getColor() {
		return c;
	}
	public ClickListener getOnClick() {
		return clickListener;
	}
	public int getType() {
		return type;
	}
	public Font getFont() {
		return font;
	}
	public int getImageType() {
		return imageType;
	}
	public boolean isBorderVisible() {
		return borders;
	}
	public Color getBorderColor() {
		return borderColor;
	}
	public Color getTextColor() {
		return textColor;
	}
	public int getTranslateX() {
		return tx;
	}
	public int getTranslateY() {
		return ty;
	}
	
}
