package com.crihexe.game.builder;

import java.awt.Graphics2D;

public abstract class GameState {
	
	private GameStateManager gsm;
	
	public GameState(GameStateManager gsm) {
		this.gsm = gsm;
		init();
	}
	
	public abstract void init();
	protected abstract void update();
	protected abstract void draw(Graphics2D g);
	protected abstract void mousePressed(int b, int x, int y);
	protected abstract void mouseReleased(int b, int x, int y);
	protected abstract void mouseMoved(int x, int y);
	protected abstract void mouseDragged(int b, int x, int y);
	protected abstract void keyPressed(int k);
	protected abstract void keyReleased(int k);
	public abstract void save();
	public abstract void finalize();
	
}
