/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.main;

import com.crihexe.main.GamePanel;
import java.awt.Color;
import java.awt.Graphics2D;

class Cell {
    public int i;
    public int j;
    boolean[] walls = new boolean[]{true, true, true, true};
    boolean visited = false;
    GamePanel panel;

    public Cell(int i, int j, GamePanel panel) {
        this.i = i;
        this.j = j;
        this.panel = panel;
    }

    public void setWalls(boolean[] walls) {
        this.walls = walls;
    }

    public Cell getNextCell(int direction) {
        if (direction == 0) {
            return this.panel.grid.get(this.panel.index(this.i, this.j - 1));
        }
        if (direction == 1) {
            return this.panel.grid.get(this.panel.index(this.i + 1, this.j));
        }
        if (direction == 2) {
            return this.panel.grid.get(this.panel.index(this.i, this.j + 1));
        }
        if (direction == 3) {
            return this.panel.grid.get(this.panel.index(this.i - 1, this.j));
        }
        return null;
    }

    public boolean[] getAvaibleCells() {
        Cell top = this.panel.grid.get(this.panel.index(this.i, this.j - 1));
        Cell right = this.panel.grid.get(this.panel.index(this.i + 1, this.j));
        Cell bottom = this.panel.grid.get(this.panel.index(this.i, this.j + 1));
        Cell left = this.panel.grid.get(this.panel.index(this.i - 1, this.j));
        boolean[] avaibleCells = new boolean[4];
        if (top != null && !this.walls[0] && !top.walls[2]) {
            avaibleCells[0] = true;
        }
        if (right != null && !this.walls[1] && !right.walls[3]) {
            avaibleCells[1] = true;
        }
        if (bottom != null && !this.walls[2] && !bottom.walls[0]) {
            avaibleCells[2] = true;
        }
        if (left != null && !this.walls[3] && !left.walls[1]) {
            avaibleCells[3] = true;
        }
        return avaibleCells;
    }

    public void show(Graphics2D g) {
        int x = this.i * this.panel.w;
        int y = this.j * this.panel.w;
        if (this == this.panel.grid.get(this.panel.grid.size() - 1)) {
            g.setColor(new Color(85, 85, 85));
            g.fillRect(x, y, this.panel.w, this.panel.w);
        }
        g.setColor(Color.white);
        if (this.walls[0]) {
            g.drawLine(x, y, x + this.panel.w, y);
        }
        if (this.walls[1]) {
            g.drawLine(x + this.panel.w, y, x + this.panel.w, y + this.panel.w);
        }
        if (this.walls[2]) {
            g.drawLine(x + this.panel.w, y + this.panel.w, x, y + this.panel.w);
        }
        if (this.walls[3]) {
            g.drawLine(x, y + this.panel.w, x, y);
        }
        if (this.visited) {
            g.setColor(new Color(255, 50, 20, 100));
            g.fillRect(x, y, this.panel.w, this.panel.w);
        }
    }
}

