/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.main;

import com.crihexe.main.Cell;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener {
    private static final long serialVersionUID = 1L;
    public static final int WIDTH = 600;
    public static final int HEIGHT = 600;
    private int FPS = 60;
    private int targetTime = this.FPS / 1000;
    private boolean running;
    private BufferedImage image;
    private Graphics2D g;
    private int cols;
    private int rows;
    public int w = 40;
    public ArrayList<Cell> grid;
    private Cell current;
    private boolean restarting;
    private Thread thread;

    public GamePanel() {
        this.setPreferredSize(new Dimension(600, 600));
        this.addKeyListener(this);
        this.setFocusable(true);
        this.addNotifify();
    }

    private void addNotifify() {
        this.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    private void restart() {
        this.restarting = true;
        this.buildDefaultTable();
        this.running = true;
        this.restarting = false;
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.init();
            Thread.sleep(500L);
            boolean p = true;
            block2: while (true) {
                if (!p) {
                    return;
                }
                while (true) {
                    long elapsed;
                    long wait;
                    if (!this.running) continue block2;
                    long start = System.nanoTime();
                    if (!this.restarting) {
                        this.draw();
                    }
                    if (!this.restarting) {
                        this.drawToScreen();
                    }
                    if ((wait = (long)this.targetTime - (elapsed = System.nanoTime() - start) / 1000000L) <= 0L) {
                        wait = 1L;
                    }
                    Thread.sleep(wait);
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.image = new BufferedImage(600, 600, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.showHelp();
        this.buildDefaultTable();
        this.running = true;
    }

    public void showHelp() {
        JFrame frame = new JFrame("Comandi");
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JLabel label1 = new JLabel("R/I = Importa nuovo labirinto");
        JLabel label2 = new JLabel("Freccette = Movimenti");
        label1.setBounds(5, 5, 250, 10);
        label2.setBounds(5, 15, 250, 10);
        panel.add(label1);
        panel.add(label2);
        frame.setBounds(750, 200, 190, 130);
        frame.setResizable(false);
        frame.setVisible(true);
        frame.add(panel);
    }

    public int index(int i, int j) {
        if (i < 0 || j < 0 || i > this.cols - 1 || j > this.rows - 1) {
            return 0;
        }
        return i + j * this.cols;
    }

    private void buildDefaultTable() {
        try {
            this.grid = new ArrayList();
            this.current = null;
            this.readMaze();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readMaze() throws Exception {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Labirinti Generati", "maze");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            File mazeFile = chooser.getSelectedFile();
            FileReader fr = new FileReader(mazeFile);
            BufferedReader br = new BufferedReader(fr);
            ArrayList<String> lines = new ArrayList<String>();
            String line = br.readLine();
            while (!line.equals("end")) {
                lines.add(line);
                line = br.readLine();
            }
            int k = 0;
            this.w = Integer.parseInt(((String)lines.get(k)).replace("cellSize:", ""));
            this.cols = (int)Math.floor(600 / this.w);
            this.rows = (int)Math.floor(600 / this.w);
            while (!((String)lines.get(k)).equals("matrix:")) {
                ++k;
            }
            ++k;
            int j = 0;
            while (j < this.rows) {
                int i = 0;
                while (i < this.cols) {
                    String[] lineData = ((String)lines.get(k)).split(";");
                    Cell cell = new Cell(Integer.parseInt(lineData[0].replace("i:", "")), Integer.parseInt(lineData[1].replace("j:", "")), this);
                    boolean[] walls = new boolean[]{Boolean.parseBoolean(lineData[2].replace("walls:{", "").replace("}", "").split(",")[0]), Boolean.parseBoolean(lineData[2].replace("walls:{", "").replace("}", "").split(",")[1]), Boolean.parseBoolean(lineData[2].replace("walls:{", "").replace("}", "").split(",")[2]), Boolean.parseBoolean(lineData[2].replace("walls:{", "").replace("}", "").split(",")[3])};
                    cell.setWalls(walls);
                    this.grid.add(cell);
                    ++k;
                    ++i;
                }
                ++j;
            }
            this.current = this.grid.get(0);
            br.close();
            fr.close();
        }
    }

    private void draw() {
        this.drawTable();
        this.g.setColor(Color.green);
        this.g.drawRect(this.grid.get((int)(this.grid.size() - 1)).i * this.w, this.grid.get((int)(this.grid.size() - 1)).j * this.w, this.w, this.w);
    }

    private void drawTable() {
        this.current.visited = true;
        this.refresh();
        int i = 0;
        while (i < this.grid.size()) {
            this.g.setColor(Color.white);
            this.grid.get(i).show(this.g);
            ++i;
        }
    }

    public void removeWalls(Cell a, Cell b) {
        int x = a.i - b.i;
        if (x == 1) {
            a.walls[3] = false;
            b.walls[1] = false;
        } else if (x == -1) {
            a.walls[1] = false;
            b.walls[3] = false;
        }
        int y = a.j - b.j;
        if (y == 1) {
            a.walls[0] = false;
            b.walls[2] = false;
        } else if (y == -1) {
            a.walls[2] = false;
            b.walls[0] = false;
        }
    }

    private void refresh() {
        Color c = this.g.getColor();
        this.g.setColor(new Color(31, 31, 31));
        this.g.fillRect(-1, -1, 1800, 1800);
        this.g.setColor(c);
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, 600, 600, null);
        g2.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 82 || e.getKeyCode() == 73) {
            this.restart();
        }
        if (e.getKeyCode() == 39 && this.current.getAvaibleCells()[1]) {
            this.current.visited = false;
            this.current = this.current.getNextCell(1);
        }
        if (e.getKeyCode() == 37 && this.current.getAvaibleCells()[3]) {
            this.current.visited = false;
            this.current = this.current.getNextCell(3);
        }
        if (e.getKeyCode() == 38 && this.current.getAvaibleCells()[0]) {
            this.current.visited = false;
            this.current = this.current.getNextCell(0);
        }
        if (e.getKeyCode() == 40 && this.current.getAvaibleCells()[2]) {
            this.current.visited = false;
            this.current = this.current.getNextCell(2);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

