/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.main;

import com.crihexe.objects.Block;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    public static final int WIDTH = 640;
    public static final int HEIGHT = 480;
    public static final int SCALE = 1;
    public static int TILESIZE = 32;
    public static final int numRows = 2;
    private String path = "grasstileset.png";
    private BufferedImage tileset;
    private BufferedImage[][] tiles;
    private int numTiles;
    private Thread thread;
    private int FPS = 30;
    private long targetTime = 1000 / this.FPS;
    private BufferedImage image;
    private Graphics2D g;
    private Block[] blocks;
    private BufferedImage currentBlockImage;
    private int currentBlock;
    private int[][] map;
    private int mapWidth;
    private int mapHeight;
    private boolean tilesetChoosen;
    private int xmap;
    private int ymap;
    private boolean shiftDown;
    private int mmx;
    private int mmy;
    private int xblock;
    private boolean ctrlDown;
    private boolean altDown;
    private int mousex;
    private int mousey;
    private int tilex;
    private int tiley;
    private int[] AIR;
    private int[] GREEN_SIDE_LEFT;
    private int[] GREEN_SIDE_RIGHT;
    private int[] BROWN_SIDE_LEFT;
    private int[] BROWN_SIDE_RIGHT;
    private int[] LEVEL_DOOR;
    private int[] FAKE_BRICKS;
    private int[] FAKE_BROWN;
    private int[] FAKE_GREEN;
    private int[] FAKE_ICE_OR_TOP_BLUE_PORTAL;
    private int[] BOTTOM_BLUE_PORTAL;
    private int[] TOP_ORANGE_PORTAL;
    private int[] BOTTOM_ORANGE_PORTAL;
    private int[] BROWN_SIDE_UP;
    private int[] BROWN_SIDE_UP_RIGHT;
    private int[] BROWN_SIDE_UP_LEFT;
    private int[] BROWN;
    private int[] GREEN;
    private int[] GREEN_ISLAND_LEFT;
    private int[] GREEN_ISLAND_MIDDLE;
    private int[] GREEN_ISALND_RIGHT;
    private int[] BRICKS;
    private int[] TUBE_UP;
    private int[] TUBE_DOWN;
    private int[] ICE;
    private int[] ICE_SLIDE;
    private int[] COIN;
    private int[] SLUGGER;
    private int[] BROCKY;
    private int[] CARROT;
    private int[] ICEFLAKE;

    public GamePanel() {
        int[] nArray = new int[4];
        nArray[1] = 255;
        nArray[2] = 255;
        nArray[3] = 255;
        this.AIR = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 150;
        nArray2[2] = 60;
        nArray2[3] = 10;
        this.GREEN_SIDE_LEFT = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 150;
        nArray3[2] = 40;
        nArray3[3] = 10;
        this.GREEN_SIDE_RIGHT = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 150;
        nArray4[1] = 50;
        nArray4[2] = 20;
        this.BROWN_SIDE_LEFT = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 150;
        nArray5[1] = 30;
        nArray5[2] = 20;
        this.BROWN_SIDE_RIGHT = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 255;
        this.LEVEL_DOOR = nArray6;
        int[] nArray7 = new int[4];
        nArray7[0] = 200;
        nArray7[1] = 255;
        nArray7[2] = 30;
        this.FAKE_BRICKS = nArray7;
        int[] nArray8 = new int[4];
        nArray8[0] = 200;
        nArray8[1] = 70;
        nArray8[2] = 20;
        this.FAKE_BROWN = nArray8;
        int[] nArray9 = new int[4];
        nArray9[0] = 200;
        nArray9[2] = 120;
        nArray9[3] = 20;
        this.FAKE_GREEN = nArray9;
        int[] nArray10 = new int[4];
        nArray10[0] = 200;
        nArray10[2] = 255;
        nArray10[3] = 255;
        this.FAKE_ICE_OR_TOP_BLUE_PORTAL = nArray10;
        int[] nArray11 = new int[4];
        nArray11[0] = 255;
        nArray11[2] = 120;
        nArray11[3] = 255;
        this.BOTTOM_BLUE_PORTAL = nArray11;
        int[] nArray12 = new int[4];
        nArray12[0] = 255;
        nArray12[1] = 255;
        nArray12[2] = 170;
        this.TOP_ORANGE_PORTAL = nArray12;
        int[] nArray13 = new int[4];
        nArray13[0] = 255;
        nArray13[1] = 255;
        nArray13[2] = 150;
        this.BOTTOM_ORANGE_PORTAL = nArray13;
        int[] nArray14 = new int[4];
        nArray14[0] = 100;
        nArray14[1] = 70;
        nArray14[2] = 20;
        this.BROWN_SIDE_UP = nArray14;
        int[] nArray15 = new int[4];
        nArray15[0] = 120;
        nArray15[1] = 70;
        nArray15[2] = 10;
        this.BROWN_SIDE_UP_RIGHT = nArray15;
        int[] nArray16 = new int[4];
        nArray16[0] = 120;
        nArray16[1] = 70;
        nArray16[2] = 30;
        this.BROWN_SIDE_UP_LEFT = nArray16;
        int[] nArray17 = new int[4];
        nArray17[0] = 255;
        nArray17[1] = 70;
        nArray17[2] = 20;
        this.BROWN = nArray17;
        int[] nArray18 = new int[4];
        nArray18[0] = 255;
        nArray18[2] = 120;
        nArray18[3] = 20;
        this.GREEN = nArray18;
        int[] nArray19 = new int[4];
        nArray19[0] = 200;
        nArray19[2] = 120;
        nArray19[3] = 10;
        this.GREEN_ISLAND_LEFT = nArray19;
        int[] nArray20 = new int[4];
        nArray20[0] = 200;
        nArray20[2] = 120;
        nArray20[3] = 20;
        this.GREEN_ISLAND_MIDDLE = nArray20;
        int[] nArray21 = new int[4];
        nArray21[0] = 200;
        nArray21[2] = 120;
        nArray21[3] = 30;
        this.GREEN_ISALND_RIGHT = nArray21;
        int[] nArray22 = new int[4];
        nArray22[0] = 255;
        nArray22[1] = 255;
        nArray22[2] = 30;
        this.BRICKS = nArray22;
        this.TUBE_UP = new int[]{255, 127, 127, 127};
        this.TUBE_DOWN = new int[]{200, 127, 127, 127};
        int[] nArray23 = new int[4];
        nArray23[0] = 255;
        nArray23[2] = 255;
        nArray23[3] = 255;
        this.ICE = nArray23;
        int[] nArray24 = new int[4];
        nArray24[0] = 125;
        nArray24[2] = 255;
        nArray24[3] = 255;
        this.ICE_SLIDE = nArray24;
        int[] nArray25 = new int[4];
        nArray25[0] = 255;
        nArray25[1] = 255;
        nArray25[2] = 238;
        this.COIN = nArray25;
        int[] nArray26 = new int[4];
        nArray26[0] = 225;
        nArray26[1] = 195;
        nArray26[3] = 255;
        this.SLUGGER = nArray26;
        int[] nArray27 = new int[4];
        nArray27[0] = 225;
        nArray27[1] = 3;
        nArray27[2] = 204;
        this.BROCKY = nArray27;
        int[] nArray28 = new int[4];
        nArray28[0] = 225;
        nArray28[1] = 204;
        nArray28[2] = 112;
        this.CARROT = nArray28;
        this.ICEFLAKE = new int[]{225, 204, 204, 204};
        this.setPreferredSize(new Dimension(960, 480));
        this.setFocusable(true);
        this.requestFocus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    @Override
    public void run() {
        try {
            this.init();
            while (true) {
                long start = System.nanoTime();
                this.update();
                this.render();
                this.draw();
                long elapsed = (System.nanoTime() - start) / 1000000L;
                long wait = this.targetTime - elapsed;
                if (wait < 0L) {
                    wait = 10L;
                }
                Thread.sleep(wait);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void init() throws Exception {
        int i;
        int width;
        this.image = new BufferedImage(960, 480, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.tilesetChoosen = false;
        this.chooseTileset();
        while (!this.tilesetChoosen) {
            Thread.sleep(1L);
        }
        this.mapWidth = 20;
        this.mapHeight = 15;
        this.map = new int[this.mapHeight][this.mapWidth];
        try {
            width = this.tileset.getWidth() / TILESIZE;
            this.numTiles = width * 2;
            this.tiles = new BufferedImage[2][width];
            i = 0;
            while (i < width) {
                this.tiles[0][i] = this.tileset.getSubimage(TILESIZE * i, 0, TILESIZE, TILESIZE);
                this.tiles[1][i] = this.tileset.getSubimage(TILESIZE * i, TILESIZE, TILESIZE, TILESIZE);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.blocks = new Block[this.numTiles];
        width = this.numTiles / 2;
        i = 0;
        while (i < width) {
            int j = 0;
            while (j < 2) {
                this.blocks[i] = new Block(this.tiles[0][i]);
                this.blocks[i].setPosition(i * TILESIZE, 480 - 2 * TILESIZE);
                this.blocks[i + width] = new Block(this.tiles[1][i]);
                this.blocks[i + width].setPosition(i * TILESIZE, 480 - TILESIZE);
                ++j;
            }
            ++i;
        }
    }

    private void chooseTileset() throws Exception {
        final JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        JButton grass = new JButton();
        grass.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/grasstileset.png"))));
        grass.setBounds(5, 5, 700, 64);
        JButton cave = new JButton();
        cave.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/cavetileset.png"))));
        cave.setBounds(5, 74, 700, 64);
        JButton candy = new JButton();
        candy.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/candytileset.png"))));
        candy.setBounds(5, 143, 700, 64);
        JButton snowy = new JButton();
        snowy.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/snowytileset.png"))));
        snowy.setBounds(5, 212, 700, 64);
        JButton acid = new JButton();
        acid.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/acidtileset.png"))));
        acid.setBounds(5, 281, 700, 64);
        JButton ocean = new JButton();
        ocean.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/oceantileset.png"))));
        ocean.setBounds(5, 350, 700, 64);
        JButton electric = new JButton();
        electric.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/electrictileset.png"))));
        electric.setBounds(5, 419, 700, 64);
        JButton choose = new JButton();
        choose.setBounds(150, 493, 400, 64);
        choose.setBackground(Color.green);
        choose.setFont(new Font("Calibri", 1, 32));
        choose.setForeground(Color.black);
        choose.setText("Scegli file personalizzato");
        panel.setLayout(null);
        grass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/grasstileset.png"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        cave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/cavetileset.png"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        candy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/candytileset.png"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        snowy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/snowytileset.png"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        acid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/acidtileset.png"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        ocean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/oceantileset.png"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        electric.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/electrictileset.png"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        choose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FileDialog dialog = new FileDialog(new JFrame());
                    dialog.setMode(0);
                    dialog.setVisible(true);
                    if (dialog.getFile() != null) {
                        while (!dialog.getFile().endsWith(".png")) {
                            dialog.dispose();
                            JOptionPane.showMessageDialog(null, "Il file non \u00e8 valido: deve avere l'estensione .png", "Errore nel caricamento", 0);
                            dialog = new FileDialog(new JFrame());
                            dialog.setMode(0);
                            dialog.setVisible(true);
                        }
                        GamePanel.this.tileset = ImageIO.read(new File(String.valueOf(dialog.getDirectory()) + dialog.getFile()));
                    } else {
                        System.exit(0);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        panel.add(grass);
        panel.add(cave);
        panel.add(candy);
        panel.add(snowy);
        panel.add(acid);
        panel.add(ocean);
        panel.add(electric);
        panel.add(choose);
        frame.add(panel);
        frame.setBounds(50, 50, 730, 600);
        frame.setDefaultCloseOperation(3);
        frame.setResizable(false);
        frame.setVisible(true);
    }

    private void chooseTileset2() throws Exception {
        final JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        JButton grass = new JButton();
        grass.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/grasstileset.png"))));
        grass.setBounds(5, 5, 700, 64);
        JButton cave = new JButton();
        cave.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/cavetileset.png"))));
        cave.setBounds(5, 74, 700, 64);
        JButton candy = new JButton();
        candy.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/candytileset.png"))));
        candy.setBounds(5, 143, 700, 64);
        JButton snowy = new JButton();
        snowy.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/snowytileset.png"))));
        snowy.setBounds(5, 212, 700, 64);
        JButton acid = new JButton();
        acid.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/acidtileset.png"))));
        acid.setBounds(5, 281, 700, 64);
        JButton ocean = new JButton();
        ocean.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/oceantileset.png"))));
        ocean.setBounds(5, 350, 700, 64);
        JButton electric = new JButton();
        electric.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/electrictileset.png"))));
        electric.setBounds(5, 419, 700, 64);
        JButton choose = new JButton();
        choose.setBounds(150, 493, 400, 64);
        choose.setBackground(Color.green);
        choose.setFont(new Font("Calibri", 1, 32));
        choose.setForeground(Color.black);
        choose.setText("Scegli file personalizzato");
        panel.setLayout(null);
        grass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/grasstileset.png"));
                    GamePanel.this.loadTileSet();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        cave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/cavetileset.png"));
                    GamePanel.this.loadTileSet();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        candy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/candytileset.png"));
                    GamePanel.this.loadTileSet();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        snowy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/snowytileset.png"));
                    GamePanel.this.loadTileSet();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        acid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/acidtileset.png"));
                    GamePanel.this.loadTileSet();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        ocean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/oceantileset.png"));
                    GamePanel.this.loadTileSet();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        electric.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GamePanel.this.tileset = ImageIO.read(this.getClass().getResourceAsStream("/electrictileset.png"));
                    GamePanel.this.loadTileSet();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        choose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FileDialog dialog = new FileDialog(new JFrame());
                    dialog.setMode(0);
                    dialog.setVisible(true);
                    if (dialog.getFile() != null) {
                        while (!dialog.getFile().endsWith(".png")) {
                            dialog.dispose();
                            JOptionPane.showMessageDialog(null, "Il file non \u00e8 valido: deve avere l'estensione .png", "Errore nel caricamento", 0);
                            dialog = new FileDialog(new JFrame());
                            dialog.setMode(0);
                            dialog.setVisible(true);
                        }
                        GamePanel.this.tileset = ImageIO.read(new File(String.valueOf(dialog.getDirectory()) + dialog.getFile()));
                        GamePanel.this.loadTileSet();
                    } else {
                        System.exit(0);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                GamePanel.this.tilesetChoosen = true;
                frame.dispose();
            }
        });
        panel.add(grass);
        panel.add(cave);
        panel.add(candy);
        panel.add(snowy);
        panel.add(acid);
        panel.add(ocean);
        panel.add(electric);
        panel.add(choose);
        frame.add(panel);
        frame.setBounds(50, 50, 730, 600);
        frame.setDefaultCloseOperation(3);
        frame.setResizable(false);
        frame.setVisible(true);
    }

    private void loadTileSet() {
        int i;
        int width;
        try {
            width = this.tileset.getWidth() / TILESIZE;
            this.numTiles = width * 2;
            this.tiles = new BufferedImage[2][width];
            i = 0;
            while (i < width) {
                this.tiles[0][i] = this.tileset.getSubimage(TILESIZE * i, 0, TILESIZE, TILESIZE);
                this.tiles[1][i] = this.tileset.getSubimage(TILESIZE * i, TILESIZE, TILESIZE, TILESIZE);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.blocks = new Block[this.numTiles];
        width = this.numTiles / 2;
        i = 0;
        while (i < width) {
            int j = 0;
            while (j < 2) {
                this.blocks[i] = new Block(this.tiles[0][i]);
                this.blocks[i].setPosition(i * TILESIZE, 480 - 2 * TILESIZE);
                this.blocks[i + width] = new Block(this.tiles[1][i]);
                this.blocks[i + width].setPosition(i * TILESIZE, 480 - TILESIZE);
                ++j;
            }
            ++i;
        }
    }

    private void update() {
    }

    private void render() {
        this.g.setColor(Color.BLACK);
        this.g.fillRect(0, 0, 640, 480);
        int row = 0;
        while (row < this.mapHeight) {
            int col = 0;
            while (col < this.mapWidth) {
                try {
                    this.g.drawImage((Image)this.blocks[this.map[row][col]].getImage(), col * TILESIZE + this.xmap, row * TILESIZE + this.ymap, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++col;
            }
            ++row;
        }
        this.g.setColor(Color.RED);
        this.g.drawRect(this.xmap, this.ymap, this.mapWidth * TILESIZE, this.mapHeight * TILESIZE);
        int bo = 480 - 2 * TILESIZE;
        this.g.setColor(Color.WHITE);
        this.g.fillRect(0, bo, 640, 2 * TILESIZE);
        int i = 0;
        while (i < this.numTiles) {
            this.blocks[i].draw(this.g);
            ++i;
        }
        this.g.setColor(Color.RED);
        int width = this.numTiles / 2;
        try {
            this.g.drawRect(this.currentBlock % width * TILESIZE + this.xblock, bo + TILESIZE * (this.currentBlock / width), TILESIZE, TILESIZE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Font font = this.g.getFont();
        this.g.setFont(new Font("Consolas", 0, 14));
        this.g.drawString("   ID: " + this.currentBlock, 505, 50);
        this.g.setColor(Color.RED);
        this.g.drawString("mouse: " + this.mousex + ", " + this.mousey, 505, 20);
        this.g.drawString(" tile: " + this.tilex + ", " + this.tiley, 505, 35);
        this.drawHelp();
        this.g.setFont(font);
    }

    private void drawHelp() {
        Color c = this.g.getColor();
        this.g.setColor(new Color(31, 31, 31));
        this.g.fillRect(640, 0, 320, 480);
        this.g.setColor(Color.white);
        this.g.setFont(new Font("Calibri", 1, 48));
        this.g.drawString("Comandi", 650, 40);
        this.g.setFont(new Font("Calibri", 0, 16));
        this.g.drawString("T = Inserisci grandezza tile", 645, 60);
        this.g.drawString("S = Salva la mappa", 645, 76);
        this.g.drawString("O = Apre una mappa", 645, 92);
        this.g.drawString("B = Cambia tileset", 645, 108);
        this.g.drawString("V = Sostituisci un blocco (ID)", 645, 124);
        this.g.drawString("Freccette = Sposta visuale", 645, 162);
        this.g.drawString("Shift + Freccette = Ridimensiona mappa", 645, 178);
        this.g.drawString("Ctrl + Freccette DX-SX = Sposta tileset", 645, 194);
        this.g.drawString("Mouse Tasto SX = ", 645, 226);
        this.g.drawString("        su mappa: Piazza blocco", 645, 240);
        this.g.drawString("        su tileset: Seleziona blocco", 645, 254);
        this.g.drawString("Mouse Tasto DX = Piazza il primo ID del tileset", 645, 284);
        this.g.drawString("        (solitamente spazio vuoto per il clear)", 645, 299);
        this.g.drawString("Mouse Rotella Premuta = Sposta visuale", 645, 332);
        this.g.drawString("Mouse Rotella Su/Gi\u00f9 = Seleziona blocco", 645, 348);
        this.g.drawString("Bordi Rossi = Bordi della mappa", 645, 396);
        this.g.drawString("Nel Tileset in basso = ", 645, 428);
        this.g.drawString("        Prima riga: Blocchi oltrepassabili", 645, 443);
        this.g.drawString("        Seconda riga: Blocchi normali", 645, 457);
        this.g.setColor(c);
    }

    private void draw() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, 960, 480, null);
        g2.dispose();
    }

    public int[] getColorToDraw(int colorID) {
        int[] color = new int[]{};
        color = this.AIR;
        color = colorID == 0 ? this.AIR : (colorID == 1 ? this.GREEN_SIDE_LEFT : (colorID == 2 ? this.GREEN_SIDE_RIGHT : (colorID == 3 ? this.BROWN_SIDE_LEFT : (colorID == 4 ? this.BROWN_SIDE_RIGHT : (colorID == 5 ? this.LEVEL_DOOR : (colorID == 6 ? this.FAKE_BRICKS : (colorID == 9 ? this.FAKE_BROWN : (colorID == 10 ? this.FAKE_GREEN : (colorID == 11 ? this.FAKE_ICE_OR_TOP_BLUE_PORTAL : (colorID == 12 ? this.BOTTOM_BLUE_PORTAL : (colorID == 13 ? this.TOP_ORANGE_PORTAL : (colorID == 14 ? this.BOTTOM_ORANGE_PORTAL : (colorID == 17 ? this.BROWN_SIDE_UP : (colorID == 18 ? this.BROWN_SIDE_UP_RIGHT : (colorID == 19 ? this.BROWN_SIDE_UP_LEFT : (colorID == 21 ? this.BROWN : (colorID == 22 ? this.GREEN : (colorID == 23 ? this.GREEN_ISLAND_LEFT : (colorID == 24 ? this.GREEN_ISLAND_MIDDLE : (colorID == 25 ? this.GREEN_ISALND_RIGHT : (colorID == 26 ? this.BRICKS : (colorID == 27 ? this.TUBE_UP : (colorID == 28 ? this.TUBE_DOWN : (colorID == 29 ? this.ICE : (colorID == 30 ? this.ICE_SLIDE : (colorID == 60 ? this.COIN : (colorID == 61 ? this.SLUGGER : (colorID == 62 ? this.BROCKY : (colorID == 63 ? this.CARROT : (colorID == 64 ? this.ICEFLAKE : this.AIR))))))))))))))))))))))))))))));
        return color;
    }

    public void writePixels(String s) {
        try {
            BufferedImage bi = new BufferedImage(this.mapWidth, this.mapHeight, 2);
            int pixel = 0;
            int row = 0;
            while (row < this.mapHeight) {
                int col = 0;
                while (col < this.mapWidth) {
                    int[] RGBToDraw = this.getColorToDraw(this.map[row][col]);
                    int alpha = RGBToDraw[0];
                    int red = RGBToDraw[1];
                    int green = RGBToDraw[2];
                    int blue = RGBToDraw[3];
                    pixel = alpha << 24 | red << 16 | green << 8 | blue;
                    bi.setRGB(col, row, pixel);
                    ++col;
                }
                ++row;
            }
            File imageFile = new File(s);
            ImageIO.write((RenderedImage)bi, "png", imageFile);
            bi.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int checkColor(int x, int y, BufferedImage imageLoad) {
        int blue;
        int green;
        int red;
        int tileID = 0;
        int pixel = imageLoad.getRGB(x, y);
        int alpha = pixel >> 24 & 0xFF;
        int[] color = new int[]{alpha, red = pixel >> 16 & 0xFF, green = pixel >> 8 & 0xFF, blue = pixel & 0xFF};
        if (color[0] == this.AIR[0] && color[1] == this.AIR[1] && color[2] == this.AIR[2] && color[3] == this.AIR[3]) {
            tileID = 0;
        }
        if (color[0] == this.GREEN_SIDE_LEFT[0] && color[1] == this.GREEN_SIDE_LEFT[1] && color[2] == this.GREEN_SIDE_LEFT[2] && color[3] == this.GREEN_SIDE_LEFT[3]) {
            tileID = 1;
        }
        if (color[0] == this.GREEN_SIDE_RIGHT[0] && color[1] == this.GREEN_SIDE_RIGHT[1] && color[2] == this.GREEN_SIDE_RIGHT[2] && color[3] == this.GREEN_SIDE_RIGHT[3]) {
            tileID = 2;
        }
        if (color[0] == this.BROWN_SIDE_LEFT[0] && color[1] == this.BROWN_SIDE_LEFT[1] && color[2] == this.BROWN_SIDE_LEFT[2] && color[3] == this.BROWN_SIDE_LEFT[3]) {
            tileID = 3;
        }
        if (color[0] == this.BROWN_SIDE_RIGHT[0] && color[1] == this.BROWN_SIDE_RIGHT[1] && color[2] == this.BROWN_SIDE_RIGHT[2] && color[3] == this.BROWN_SIDE_RIGHT[3]) {
            tileID = 4;
        }
        if (color[0] == this.LEVEL_DOOR[0] && color[1] == this.LEVEL_DOOR[1] && color[2] == this.LEVEL_DOOR[2] && color[3] == this.LEVEL_DOOR[3]) {
            tileID = 5;
        }
        if (color[0] == this.FAKE_BRICKS[0] && color[1] == this.FAKE_BRICKS[1] && color[2] == this.FAKE_BRICKS[2] && color[3] == this.FAKE_BRICKS[3]) {
            tileID = 6;
        }
        if (color[0] == this.FAKE_BROWN[0] && color[1] == this.FAKE_BROWN[1] && color[2] == this.FAKE_BROWN[2] && color[3] == this.FAKE_BROWN[3]) {
            tileID = 9;
        }
        if (color[0] == this.FAKE_GREEN[0] && color[1] == this.FAKE_GREEN[1] && color[2] == this.FAKE_GREEN[2] && color[3] == this.FAKE_GREEN[3]) {
            tileID = 10;
        }
        if (color[0] == this.FAKE_ICE_OR_TOP_BLUE_PORTAL[0] && color[1] == this.FAKE_ICE_OR_TOP_BLUE_PORTAL[1] && color[2] == this.FAKE_ICE_OR_TOP_BLUE_PORTAL[2] && color[3] == this.FAKE_ICE_OR_TOP_BLUE_PORTAL[3]) {
            tileID = 11;
        }
        if (color[0] == this.BOTTOM_BLUE_PORTAL[0] && color[1] == this.BOTTOM_BLUE_PORTAL[1] && color[2] == this.BOTTOM_BLUE_PORTAL[2] && color[3] == this.BOTTOM_BLUE_PORTAL[3]) {
            tileID = 12;
        }
        if (color[0] == this.TOP_ORANGE_PORTAL[0] && color[1] == this.TOP_ORANGE_PORTAL[1] && color[2] == this.TOP_ORANGE_PORTAL[2] && color[3] == this.TOP_ORANGE_PORTAL[3]) {
            tileID = 13;
        }
        if (color[0] == this.BOTTOM_ORANGE_PORTAL[0] && color[1] == this.BOTTOM_ORANGE_PORTAL[1] && color[2] == this.BOTTOM_ORANGE_PORTAL[2] && color[3] == this.BOTTOM_ORANGE_PORTAL[3]) {
            tileID = 14;
        }
        if (color[0] == this.BROWN_SIDE_UP[0] && color[1] == this.BROWN_SIDE_UP[1] && color[2] == this.BROWN_SIDE_UP[2] && color[3] == this.BROWN_SIDE_UP[3]) {
            tileID = 17;
        }
        if (color[0] == this.BROWN_SIDE_UP_RIGHT[0] && color[1] == this.BROWN_SIDE_UP_RIGHT[1] && color[2] == this.BROWN_SIDE_UP_RIGHT[2] && color[3] == this.BROWN_SIDE_UP_RIGHT[3]) {
            tileID = 18;
        }
        if (color[0] == this.BROWN_SIDE_UP_LEFT[0] && color[1] == this.BROWN_SIDE_UP_LEFT[1] && color[2] == this.BROWN_SIDE_UP_LEFT[2] && color[3] == this.BROWN_SIDE_UP_LEFT[3]) {
            tileID = 19;
        }
        if (color[0] == this.GREEN[0] && color[1] == this.GREEN[1] && color[2] == this.GREEN[2] && color[3] == this.GREEN[3]) {
            tileID = 22;
        }
        if (color[0] == this.BROWN[0] && color[1] == this.BROWN[1] && color[2] == this.BROWN[2] && color[3] == this.BROWN[3]) {
            tileID = 21;
        }
        if (color[0] == this.GREEN_ISLAND_LEFT[0] && color[1] == this.GREEN_ISLAND_LEFT[1] && color[2] == this.GREEN_ISLAND_LEFT[2] && color[3] == this.GREEN_ISLAND_LEFT[3]) {
            tileID = 23;
        }
        if (color[0] == this.GREEN_ISLAND_MIDDLE[0] && color[1] == this.GREEN_ISLAND_MIDDLE[1] && color[2] == this.GREEN_ISLAND_MIDDLE[2] && color[3] == this.GREEN_ISLAND_MIDDLE[3]) {
            tileID = 24;
        }
        if (color[0] == this.GREEN_ISALND_RIGHT[0] && color[1] == this.GREEN_ISALND_RIGHT[1] && color[2] == this.GREEN_ISALND_RIGHT[2] && color[3] == this.GREEN_ISALND_RIGHT[3]) {
            tileID = 25;
        }
        if (color[0] == this.BRICKS[0] && color[1] == this.BRICKS[1] && color[2] == this.BRICKS[2] && color[3] == this.BRICKS[3]) {
            tileID = 26;
        }
        if (color[0] == this.TUBE_UP[0] && color[1] == this.TUBE_UP[1] && color[2] == this.TUBE_UP[2] && color[3] == this.TUBE_UP[3]) {
            tileID = 27;
        }
        if (color[0] == this.TUBE_DOWN[0] && color[1] == this.TUBE_DOWN[1] && color[2] == this.TUBE_DOWN[2] && color[3] == this.TUBE_DOWN[3]) {
            tileID = 28;
        }
        if (color[0] == this.ICE[0] && color[1] == this.ICE[1] && color[2] == this.ICE[2] && color[3] == this.ICE[3]) {
            tileID = 29;
        }
        if (color[0] == this.ICE_SLIDE[0] && color[1] == this.ICE_SLIDE[1] && color[2] == this.ICE_SLIDE[2] && color[3] == this.ICE_SLIDE[3]) {
            tileID = 30;
        }
        if (color[0] == this.COIN[0] && color[1] == this.COIN[1] && color[2] == this.COIN[2] && color[3] == this.COIN[3]) {
            tileID = 60;
        }
        if (color[0] == this.SLUGGER[0] && color[1] == this.SLUGGER[1] && color[2] == this.SLUGGER[2] && color[3] == this.SLUGGER[3]) {
            tileID = 61;
        }
        if (color[0] == this.BROCKY[0] && color[1] == this.BROCKY[1] && color[2] == this.BROCKY[2] && color[3] == this.BROCKY[3]) {
            tileID = 62;
        }
        if (color[0] == this.CARROT[0] && color[1] == this.CARROT[1] && color[2] == this.CARROT[2] && color[3] == this.CARROT[3]) {
            tileID = 63;
        }
        if (color[0] == this.ICEFLAKE[0] && color[1] == this.ICEFLAKE[1] && color[2] == this.ICEFLAKE[2] && color[3] == this.ICEFLAKE[3]) {
            tileID = 64;
        }
        return tileID;
    }

    @Override
    public void keyTyped(KeyEvent key) {
    }

    @Override
    public void keyPressed(KeyEvent key) {
        int col;
        int row;
        int i;
        String str;
        int k = key.getKeyCode();
        if (k == 16) {
            this.shiftDown = true;
        }
        if (k == 17) {
            this.ctrlDown = true;
        }
        if (k == 84) {
            str = JOptionPane.showInputDialog(null, "Inserisci la grandezza della tile:", 32);
            TILESIZE = i = Integer.parseInt(str);
        }
        if (k == 83) {
            try {
                FileDialog dialog = new FileDialog((Frame)new JFrame(), "Salva", 1);
                dialog.setFile("map");
                dialog.setVisible(true);
                this.writePixels(String.valueOf(dialog.getDirectory()) + dialog.getFile() + ".png");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (k == 79) {
            str = null;
            try {
                FileDialog dialog = new FileDialog(new JFrame());
                dialog.setMode(0);
                dialog.setVisible(true);
                if (dialog.getFile() != null) {
                    while (!dialog.getFile().endsWith(".png")) {
                        dialog.dispose();
                        JOptionPane.showMessageDialog(null, "Il file non \u00e8 valido: deve avere l'estensione .png", "Errore nel caricamento", 0);
                        dialog = new FileDialog(new JFrame());
                        dialog.setMode(0);
                        dialog.setVisible(true);
                    }
                    File mapFile = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
                    BufferedImage bi = ImageIO.read(mapFile);
                    this.mapWidth = bi.getWidth();
                    this.mapHeight = bi.getHeight();
                    this.map = new int[this.mapHeight][this.mapWidth];
                    int row2 = 0;
                    while (row2 < this.mapHeight) {
                        int col2 = 0;
                        while (col2 < this.mapWidth) {
                            this.map[row2][col2] = this.checkColor(col2, row2, bi);
                            ++col2;
                        }
                        ++row2;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (k == 66) {
            try {
                this.chooseTileset2();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (k == 86) {
            try {
                int source = Integer.parseInt(JOptionPane.showInputDialog(null, "ID vecchio blocco", 1));
                int dest = Integer.parseInt(JOptionPane.showInputDialog(null, "ID nuovo blocco", 1));
                int row3 = 0;
                while (row3 < this.mapHeight) {
                    int col3 = 0;
                    while (col3 < this.mapWidth) {
                        if (this.map[row3][col3] == source) {
                            this.map[row3][col3] = dest;
                        }
                        ++col3;
                    }
                    ++row3;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (k == 39) {
            if (this.shiftDown) {
                ++this.mapWidth;
                int[][] temp = new int[this.mapHeight][this.mapWidth];
                row = 0;
                while (row < this.mapHeight) {
                    int col4 = 0;
                    while (col4 < this.mapWidth - 1) {
                        temp[row][col4] = this.map[row][col4];
                        ++col4;
                    }
                    ++row;
                }
                this.map = temp;
            } else if (this.ctrlDown) {
                this.xblock += TILESIZE;
                int width = this.numTiles / 2;
                i = 0;
                while (i < width) {
                    this.blocks[i].setPosition(i * TILESIZE + this.xblock, 480 - 2 * TILESIZE);
                    this.blocks[i + width].setPosition(i * TILESIZE + this.xblock, 480 - TILESIZE);
                    ++i;
                }
            } else if (this.altDown) {
                int row4 = 0;
                while (row4 < this.mapHeight) {
                    col = this.mapWidth - 1;
                    while (col > 0) {
                        this.map[row4][col] = this.map[row4][col - 1];
                        --col;
                    }
                    this.map[row4][0] = 0;
                    ++row4;
                }
            } else {
                this.xmap -= TILESIZE;
            }
        }
        if (k == 37) {
            if (this.shiftDown) {
                --this.mapWidth;
                int[][] temp = new int[this.mapHeight][this.mapWidth];
                row = 0;
                while (row < this.mapHeight) {
                    int col5 = 0;
                    while (col5 < this.mapWidth) {
                        temp[row][col5] = this.map[row][col5];
                        ++col5;
                    }
                    ++row;
                }
                this.map = temp;
            } else if (this.ctrlDown) {
                this.xblock -= TILESIZE;
                int width = this.numTiles / 2;
                i = 0;
                while (i < width) {
                    this.blocks[i].setPosition(i * TILESIZE + this.xblock, 480 - 2 * TILESIZE);
                    this.blocks[i + width].setPosition(i * TILESIZE + this.xblock, 480 - TILESIZE);
                    ++i;
                }
            } else if (this.altDown) {
                int row5 = 0;
                while (row5 < this.mapHeight) {
                    col = 0;
                    while (col < this.mapWidth - 1) {
                        this.map[row5][col] = this.map[row5][col + 1];
                        ++col;
                    }
                    this.map[row5][this.mapWidth - 1] = 0;
                    ++row5;
                }
            } else {
                this.xmap += TILESIZE;
            }
        }
        if (k == 38) {
            if (this.shiftDown) {
                --this.mapHeight;
                int[][] temp = new int[this.mapHeight][this.mapWidth];
                row = 0;
                while (row < this.mapHeight) {
                    int col6 = 0;
                    while (col6 < this.mapWidth) {
                        temp[row][col6] = this.map[row][col6];
                        ++col6;
                    }
                    ++row;
                }
                this.map = temp;
            } else if (this.altDown) {
                int col7 = 0;
                while (col7 < this.mapWidth) {
                    row = 0;
                    while (row < this.mapHeight - 1) {
                        this.map[row][col7] = this.map[row + 1][col7];
                        ++row;
                    }
                    this.map[this.mapHeight - 1][col7] = 0;
                    ++col7;
                }
            } else {
                this.ymap += TILESIZE;
            }
        }
        if (k == 40) {
            if (this.shiftDown) {
                ++this.mapHeight;
                int[][] temp = new int[this.mapHeight][this.mapWidth];
                row = 0;
                while (row < this.mapHeight - 1) {
                    int col8 = 0;
                    while (col8 < this.mapWidth) {
                        temp[row][col8] = this.map[row][col8];
                        ++col8;
                    }
                    ++row;
                }
                this.map = temp;
            } else if (this.altDown) {
                int col9 = 0;
                while (col9 < this.mapWidth) {
                    row = this.mapHeight - 1;
                    while (row > 0) {
                        this.map[row][col9] = this.map[row - 1][col9];
                        --row;
                    }
                    this.map[0][col9] = 0;
                    ++col9;
                }
            } else {
                this.ymap -= TILESIZE;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent key) {
        int k = key.getKeyCode();
        if (k == 16) {
            this.shiftDown = false;
        }
        if (k == 17) {
            this.ctrlDown = false;
        }
        if (k == 18) {
            this.altDown = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (SwingUtilities.isLeftMouseButton(me)) {
            int y = me.getY() / 1;
            int x = me.getX() / 1 - this.xblock;
            int b = 0;
            if (y >= 480 - 2 * TILESIZE) {
                b = x / TILESIZE;
                if (y >= 480 - 1 * TILESIZE) {
                    b = x / TILESIZE + this.numTiles / 2;
                }
                this.currentBlockImage = this.blocks[b].getImage();
                this.currentBlock = b;
            } else {
                y = me.getY() / 1 - this.ymap;
                x = me.getX() / 1 - this.xmap;
                if (x > 0 && x < this.mapWidth * TILESIZE && y > 0 && y < this.mapHeight * TILESIZE) {
                    this.map[y / GamePanel.TILESIZE][x / GamePanel.TILESIZE] = this.currentBlock;
                }
            }
        } else if (SwingUtilities.isRightMouseButton(me)) {
            int y = me.getY() / 1 - this.ymap;
            int x = me.getX() / 1 - this.xmap;
            if (x > 0 && x < this.mapWidth * TILESIZE && y > 0 && y < this.mapHeight * TILESIZE) {
                this.map[y / GamePanel.TILESIZE][x / GamePanel.TILESIZE] = 0;
            }
        } else if (SwingUtilities.isMiddleMouseButton(me)) {
            this.mmx = me.getX();
            this.mmy = me.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (SwingUtilities.isLeftMouseButton(me)) {
            int y = me.getY() / 1;
            if (y < 480 - 2 * TILESIZE) {
                y = me.getY() / 1 - this.ymap;
                int x = me.getX() / 1 - this.xmap;
                if (x > 0 && x < this.mapWidth * TILESIZE && y > 0 && y < this.mapHeight * TILESIZE) {
                    this.map[y / GamePanel.TILESIZE][x / GamePanel.TILESIZE] = this.currentBlock;
                }
            }
        } else if (SwingUtilities.isRightMouseButton(me)) {
            int y = me.getY() / 1 - this.ymap;
            int x = me.getX() / 1 - this.xmap;
            if (x > 0 && x < this.mapWidth * TILESIZE && y > 0 && y < this.mapHeight * TILESIZE) {
                this.map[y / GamePanel.TILESIZE][x / GamePanel.TILESIZE] = 0;
            }
        } else if (SwingUtilities.isMiddleMouseButton(me)) {
            int y = me.getY();
            int x = me.getX();
            int dx = (x - this.mmx) / TILESIZE;
            int dy = (y - this.mmy) / TILESIZE;
            if (dx != 0 || dy != 0) {
                this.mmx = me.getX();
                this.mmy = me.getY();
                this.xmap += dx * TILESIZE;
                this.ymap += dy * TILESIZE;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.mousex = me.getX() - this.xmap;
        this.mousey = me.getY() - this.ymap;
        this.tilex = this.mousex / TILESIZE;
        this.tiley = this.mousey / TILESIZE;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int notches = mwe.getWheelRotation();
        this.currentBlock = notches < 0 ? --this.currentBlock : ++this.currentBlock;
    }
}

