/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.panels;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TilesetPanel
extends JPanel
implements Runnable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 800;
    private static final int HEIGHT = 600;
    private int FPS = 30;
    private long targetTime = 1000 / this.FPS;
    private Graphics2D g;
    private BufferedImage image;
    private Thread thread;
    private boolean running;

    public TilesetPanel() {
        this.setPreferredSize(new Dimension(800, 600));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(true);
        this.addNotifify();
    }

    private void addNotifify() {
        this.addNotify();
        if (this.thread != null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        try {
            this.init();
            Thread.sleep(500L);
            while (this.running) {
                long start = System.nanoTime();
                this.update();
                this.draw();
                this.drawToScreen();
                long elapsed = (System.nanoTime() - start) / 1000000L;
                long wait = this.targetTime - elapsed;
                if (wait < 0L) {
                    wait = 10L;
                }
                Thread.sleep(wait);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.image = new BufferedImage(800, 600, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.running = true;
    }

    private void update() {
    }

    private void draw() {
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, 800, 600, null);
        g2.dispose();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

