/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.main;

import com.crihexe.entities.Drop;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Random;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public static final int WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width;
    public static final int HEIGHT = Toolkit.getDefaultToolkit().getScreenSize().height;
    private int FPS = 800;
    private long targetTime = this.FPS / 1000;
    private Graphics2D g;
    private BufferedImage image;
    private boolean running;
    private int mx;
    private int my;
    private double velocity;
    private int dropScale;
    private boolean isPaused;
    private boolean showStarting;
    private Thread thread;
    private Drop[] drop;
    private Random random;

    public GamePanel() {
        this.setPreferredSize(new Dimension(WIDTH, HEIGHT));
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(true);
        this.addNotifify();
    }

    private void addNotifify() {
        this.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        try {
            this.init();
            Thread.sleep(500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (this.running) {
            long start = System.nanoTime();
            this.update();
            this.draw();
            this.drawToScreen();
            long elapsed = System.nanoTime() - start;
            long wait = this.targetTime - elapsed / 1000000L;
            if (wait <= 0L) {
                wait = 5L;
            }
            try {
                Thread.sleep(wait);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void init() throws Exception {
        this.image = new BufferedImage(WIDTH, HEIGHT, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.random = new Random();
        this.isPaused = false;
        this.dropScale = 1;
        this.drop = new Drop[700 + this.random.nextInt(1300)];
        this.buildDefaultRain();
        this.showStarting = true;
        Timer timer = new Timer(8000, e -> {
            int i = 0;
            while (i < this.drop.length) {
                this.drop[i].setMoveSpeed(this.drop[i].getMoveSpeed() - 3.0);
                ++i;
            }
            this.velocity = 1.0;
            this.showStarting = false;
        });
        timer.setRepeats(false);
        timer.start();
        this.running = true;
    }

    private void buildDefaultRain() {
        int i = 0;
        while (i < this.drop.length) {
            Point position = new Point(this.random.nextInt(WIDTH), -20);
            this.drop[i] = new Drop(position.x, position.y, 2.45 + 1.15 * this.random.nextDouble() + 3.0);
            ++i;
        }
        this.velocity = 2000.0;
    }

    private void update() {
        if (!this.isPaused) {
            int i = 0;
            while (i < this.drop.length) {
                Drop d = this.drop[i];
                d.update();
                if (d.getY() > (double)(HEIGHT + 8)) {
                    d.setPosition(d.getX(), -8.0);
                }
                if (d.getX() > (double)WIDTH) {
                    d.setPosition(-0.1, d.getY());
                }
                ++i;
            }
        }
    }

    private void draw() {
        this.g.setColor(Color.white);
        this.g.fillRect(0, 0, WIDTH, HEIGHT);
        this.g.setColor(Color.magenta);
        int i = 0;
        while (i < this.drop.length) {
            this.g.fillRect((int)this.drop[i].getX(), (int)this.drop[i].getY(), this.dropScale + 1, 8 + this.dropScale);
            ++i;
        }
        this.g.setColor(Color.black);
        this.g.drawString("Velocit\u00e0: " + new DecimalFormat("x0.0").format(this.velocity), this.mx, this.my);
        this.g.drawString("Scala: x" + this.dropScale, this.mx, this.my + 10);
        if (this.isPaused) {
            this.g.drawString("Stop", this.mx, this.my - 10);
        }
        if (this.showStarting) {
            this.g.drawString("INIZIO, ATTENDERE", this.mx, this.my - 25);
        }
        this.g.drawString("SpawnRate: 700-1300", 2, 12);
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, WIDTH, HEIGHT, null);
        g2.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int i;
        if (e.getKeyCode() == 39) {
            i = 0;
            while (i < this.drop.length) {
                this.drop[i].setMoveSpeed(this.drop[i].getMoveSpeed() + 0.1);
                this.velocity += 1.0E-4;
                ++i;
            }
        }
        if (e.getKeyCode() == 37) {
            i = 0;
            while (i < this.drop.length) {
                if (!(this.drop[i].getMoveSpeed() < 0.6)) {
                    this.drop[i].setMoveSpeed(this.drop[i].getMoveSpeed() - 0.1);
                    this.velocity -= 1.0E-4;
                }
                ++i;
            }
        }
        if (e.getKeyCode() == 38) {
            ++this.dropScale;
        }
        if (e.getKeyCode() == 40 && this.dropScale - 1 >= 0) {
            --this.dropScale;
        }
        if (e.getKeyCode() == 32) {
            this.isPaused = !this.isPaused;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mx = e.getX();
        this.my = e.getY() - 10;
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

