/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.main;

import com.crihexe.entities.Apple;
import com.crihexe.entities.Snake;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 991;
    private static final int HEIGHT = 581;
    private int FPS = 5;
    private final long targetTime = this.FPS / 1000;
    private Graphics2D g;
    private BufferedImage image;
    private BufferedImage head;
    private BufferedImage body;
    private BufferedImage tail;
    private BufferedImage angle_body;
    private boolean isBoosting;
    private boolean running;
    private int points;
    private int deaths = -1;
    private Timer timer;
    private AffineTransform identity = new AffineTransform();
    private AffineTransform trans = new AffineTransform();
    private int graphicMode;
    private int w;
    private boolean changedDirection;
    private Thread thread;
    private Random random;
    private ArrayList<Snake> snake;
    private Apple apple;

    public GamePanel() {
        this.setPreferredSize(new Dimension(991, 581));
        this.addKeyListener(this);
        this.setFocusable(true);
        this.addNotifify();
    }

    private void addNotifify() {
        this.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        try {
            this.init();
            Thread.sleep(500L);
            while (this.running) {
                long start = System.nanoTime();
                this.drawToScreen();
                long elapsed = System.nanoTime() - start;
                long wait = this.targetTime - elapsed / 1000000L;
                if (wait <= 0L) {
                    wait = 5L;
                }
                Thread.sleep(wait);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() throws Exception {
        this.points = 2;
        this.image = new BufferedImage(991, 581, 1);
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer = new Timer(215, e -> {
            try {
                this.update();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        this.timer.setDelay(this.timer.getDelay() * 3);
        this.isBoosting = false;
        this.graphicMode = 2;
        ++this.deaths;
        this.g = (Graphics2D)this.image.getGraphics();
        this.g.translate(5, 55);
        this.random = new Random();
        this.w = 32;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.snake = null;
        this.changedDirection = false;
        this.buildDefaultTable();
        this.timer.setRepeats(true);
        this.timer.start();
        this.running = true;
    }

    private BufferedImage loadSprites(String path) throws Exception {
        return ImageIO.read(this.getClass().getResourceAsStream(path));
    }

    private void buildDefaultTable() throws Exception {
        this.snake = new ArrayList();
        BufferedImage[] snakeHead = new BufferedImage[]{};
        this.snake.add(new Snake(6, 4, 1.0, 10, snakeHead, 2, this));
        this.snake.get(0).setPosition(6, 5);
        this.snake.get(0).setPosition(6, 6);
        int x = this.random.nextInt(20);
        int y = this.random.nextInt(15);
        while (x == 6) {
            x = this.random.nextInt(20);
        }
        while (y == 6 || y == 7 || y == 8) {
            y = this.random.nextInt(15);
        }
        this.apple = new Apple(x, y, this.loadSprites("/apple.png"));
        this.head = this.loadSprites("/head.png");
        this.body = this.loadSprites("/body.png");
        this.angle_body = this.loadSprites("/angle_body.png");
        this.tail = this.loadSprites("/tail.png");
    }

    private void update() throws Exception {
        this.snake.get(0).update();
        this.changedDirection = false;
        this.draw();
        this.checkWin();
    }

    private void checkWin() throws Exception {
        if (this.points >= 299) {
            this.g.drawImage((Image)ImageIO.read(this.getClass().getResourceAsStream("/win.png")), -5, -80, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void checkEat() {
        block4: {
            if (this.snake.get(0).getX() != this.apple.getX() || this.snake.get(0).getY() != this.apple.getY()) break block4;
            x = this.random.nextInt(20);
            y = this.random.nextInt(15);
            i = 0;
            ** GOTO lbl10
            {
                x = this.random.nextInt(20);
                do {
                    if ((double)x == this.snake.get(0).getStack().get(i).getX() || x == this.snake.get(0).getX()) continue block0;
                    ++i;
lbl10:
                    // 2 sources

                } while (i < this.snake.get(0).getStack().size());
            }
            i = 0;
            ** GOTO lbl17
            {
                y = this.random.nextInt(15);
                do {
                    if (y == this.snake.get(0).getY() || (double)y == this.snake.get(0).getStack().get(i).getY() || (double)y == this.snake.get(0).getStack().get(i).getY() || (double)y == this.snake.get(0).getStack().get(i).getY()) continue block2;
                    ++i;
lbl17:
                    // 2 sources

                } while (i < this.snake.get(0).getStack().size());
            }
            this.apple.setPosition(x, y);
            this.snake.get(0).addTail();
            ++this.points;
        }
    }

    private void draw() {
        try {
            this.drawTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawTable() throws Exception {
        this.refresh();
        this.g.drawImage(this.apple.getSprite(), this.apple.getX() * this.w, this.apple.getY() * this.w, this.w, this.w, null);
        this.g.setColor(new Color(41, 41, 41));
        int j = 0;
        while (j < 15) {
            int i = 0;
            while (i < 20) {
                this.g.drawRect(i * this.w, j * this.w, this.w, this.w);
                ++i;
            }
            ++j;
        }
        this.g.setColor(Color.white);
        int i = this.snake.get(0).getStack().size() - 1;
        while (i >= this.snake.get(0).getStack().size() - this.snake.get(0).getLength()) {
            if (this.graphicMode == 1) {
                this.g.setColor(new Color(255, 255, 255, 200));
                this.g.fillRect(this.snake.get((int)0).getStack().get((int)i).x * this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w, this.w, this.w);
            } else if (this.graphicMode == 2) {
                if (i == this.snake.get(0).getStack().size() - 1) {
                    if (this.snake.get(0).getDirection() == 1.0) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w);
                        this.trans.scale(2.0, 2.0);
                    } else if (this.snake.get(0).getDirection() == 2.0) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w + this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w);
                        this.trans.scale(2.0, 2.0);
                        this.trans.rotate(Math.toRadians(90.0));
                    } else if (this.snake.get(0).getDirection() == 3.0) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w + this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w + this.w);
                        this.trans.scale(2.0, 2.0);
                        this.trans.rotate(Math.toRadians(180.0));
                    } else if (this.snake.get(0).getDirection() == 4.0) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w + this.w);
                        this.trans.scale(2.0, 2.0);
                        this.trans.rotate(Math.toRadians(270.0));
                    }
                    this.g.drawImage(this.head, this.trans, null);
                } else if (i < this.snake.get(0).getStack().size() - 1 && i != this.snake.get(0).getStack().size() - this.snake.get(0).getLength()) {
                    if (this.snake.get((int)0).getStack().get((int)(i - 1)).y > this.snake.get((int)0).getStack().get((int)i).y && this.snake.get((int)0).getStack().get((int)(i + 1)).x > this.snake.get((int)0).getStack().get((int)i).x || this.snake.get((int)0).getStack().get((int)(i + 1)).y > this.snake.get((int)0).getStack().get((int)i).y && this.snake.get((int)0).getStack().get((int)(i - 1)).x > this.snake.get((int)0).getStack().get((int)i).x) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w);
                        this.trans.scale(2.0, 2.0);
                        this.g.drawImage(this.angle_body, this.trans, null);
                    } else if (this.snake.get((int)0).getStack().get((int)(i - 1)).x > this.snake.get((int)0).getStack().get((int)i).x && this.snake.get((int)0).getStack().get((int)(i + 1)).y < this.snake.get((int)0).stack.get((int)i).y || this.snake.get((int)0).getStack().get((int)(i + 1)).x > this.snake.get((int)0).getStack().get((int)i).x && this.snake.get((int)0).getStack().get((int)(i - 1)).y < this.snake.get((int)0).stack.get((int)i).y) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w + this.w);
                        this.trans.scale(2.0, 2.0);
                        this.trans.rotate(Math.toRadians(270.0));
                        this.g.drawImage(this.angle_body, this.trans, null);
                    } else if (this.snake.get((int)0).getStack().get((int)(i - 1)).y < this.snake.get((int)0).stack.get((int)i).y && this.snake.get((int)0).getStack().get((int)(i + 1)).x < this.snake.get((int)0).getStack().get((int)i).x || this.snake.get((int)0).getStack().get((int)(i + 1)).y < this.snake.get((int)0).stack.get((int)i).y && this.snake.get((int)0).getStack().get((int)(i - 1)).x < this.snake.get((int)0).getStack().get((int)i).x) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w + this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w + this.w);
                        this.trans.scale(2.0, 2.0);
                        this.trans.rotate(Math.toRadians(180.0));
                        this.g.drawImage(this.angle_body, this.trans, null);
                    } else if (this.snake.get((int)0).getStack().get((int)i).y < this.snake.get((int)0).stack.get((int)(i + 1)).y && this.snake.get((int)0).getStack().get((int)(i - 1)).x < this.snake.get((int)0).getStack().get((int)i).x || this.snake.get((int)0).getStack().get((int)(i - 1)).y > this.snake.get((int)0).stack.get((int)i).y && this.snake.get((int)0).getStack().get((int)(i + 1)).x < this.snake.get((int)0).getStack().get((int)i).x) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w + this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w);
                        this.trans.scale(2.0, 2.0);
                        this.trans.rotate(Math.toRadians(90.0));
                        this.g.drawImage(this.angle_body, this.trans, null);
                    } else {
                        if (this.snake.get((int)0).getStack().get((int)(i + 1)).x > this.snake.get((int)0).getStack().get((int)i).x) {
                            this.trans.setTransform(this.identity);
                            this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w + this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w);
                            this.trans.scale(2.0, 2.0);
                            this.trans.rotate(Math.toRadians(90.0));
                        } else if (this.snake.get((int)0).getStack().get((int)(i + 1)).x < this.snake.get((int)0).getStack().get((int)i).x) {
                            this.trans.setTransform(this.identity);
                            this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w + this.w);
                            this.trans.scale(2.0, 2.0);
                            this.trans.rotate(Math.toRadians(270.0));
                        } else if (this.snake.get((int)0).getStack().get((int)(i + 1)).y > this.snake.get((int)0).getStack().get((int)i).y) {
                            this.trans.setTransform(this.identity);
                            this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w + this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w + this.w);
                            this.trans.scale(2.0, 2.0);
                            this.trans.rotate(Math.toRadians(180.0));
                        } else if (this.snake.get((int)0).getStack().get((int)(i + 1)).y < this.snake.get((int)0).getStack().get((int)i).y) {
                            this.trans.setTransform(this.identity);
                            this.trans.translate(this.snake.get((int)0).getStack().get((int)i).x * this.w, this.snake.get((int)0).getStack().get((int)i).y * this.w);
                            this.trans.scale(2.0, 2.0);
                        }
                        this.g.drawImage(this.body, this.trans, null);
                    }
                } else if (i == this.snake.get(0).getStack().size() - this.snake.get(0).getLength()) {
                    if (this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength() + 1)).x > this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).x) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).x * this.w + this.w, this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).y * this.w);
                        this.trans.scale(2.0, 2.0);
                        this.trans.rotate(Math.toRadians(90.0));
                    } else if (this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength() + 1)).x < this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).x) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).x * this.w, this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).y * this.w + this.w);
                        this.trans.scale(2.0, 2.0);
                        this.trans.rotate(Math.toRadians(270.0));
                    } else if (this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength() + 1)).y > this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).y) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).x * this.w + this.w, this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).y * this.w + this.w);
                        this.trans.scale(2.0, 2.0);
                        this.trans.rotate(Math.toRadians(180.0));
                    } else if (this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength() + 1)).y < this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).y) {
                        this.trans.setTransform(this.identity);
                        this.trans.translate(this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).x * this.w, this.snake.get((int)0).getStack().get((int)(this.snake.get((int)0).getStack().size() - this.snake.get((int)0).getLength())).y * this.w);
                        this.trans.scale(2.0, 2.0);
                    }
                    this.g.drawImage(this.tail, this.trans, null);
                }
            }
            --i;
        }
        this.g.setColor(Color.white);
        Font font = this.g.getFont();
        this.g.setFont(new Font("Calibri", 1, 32));
        this.g.drawString("Comandi:", 645, 23);
        this.g.setFont(font);
        this.g.drawString("Freccette: Movimento", 645, 55);
        this.g.drawString("Spazio: Boost Velocit\u00e0", 645, 70);
        this.g.drawString("G: Cambio grafica: low - high", 645, 85);
        this.g.setFont(new Font("Calibri", 1, 48));
        this.g.drawString("Punti: " + this.points, 1, -15);
        this.g.drawString("Morti: " + this.deaths, 475, -15);
        this.g.setFont(font);
    }

    private void refresh() {
        Color c = this.g.getColor();
        this.g.setColor(new Color(31, 31, 31));
        this.g.fillRect(-991, -581, 1982, 1162);
        this.g.setColor(c);
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, 991, 581, null);
        g2.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38 && this.snake.get(0).getDirection() != 3.0 && this.snake.get(0).getDirection() != 1.0 && !this.changedDirection) {
            this.snake.get(0).setDirection(1.0);
            this.changedDirection = true;
        }
        if (e.getKeyCode() == 39 && this.snake.get(0).getDirection() != 4.0 && this.snake.get(0).getDirection() != 2.0 && !this.changedDirection) {
            this.snake.get(0).setDirection(2.0);
            this.changedDirection = true;
        }
        if (e.getKeyCode() == 40 && this.snake.get(0).getDirection() != 1.0 && this.snake.get(0).getDirection() != 3.0 && !this.changedDirection) {
            this.snake.get(0).setDirection(3.0);
            this.changedDirection = true;
        }
        if (e.getKeyCode() == 37 && this.snake.get(0).getDirection() != 2.0 && this.snake.get(0).getDirection() != 4.0 && !this.changedDirection) {
            this.snake.get(0).setDirection(4.0);
            this.changedDirection = true;
        }
        if (e.getKeyCode() == 32 && !this.isBoosting) {
            this.timer.setDelay(this.timer.getDelay() / 3);
            this.isBoosting = true;
        }
        if (e.getKeyCode() == 71) {
            this.graphicMode = this.graphicMode == 2 ? --this.graphicMode : (this.graphicMode == 1 ? ++this.graphicMode : 1);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32 && this.isBoosting) {
            this.timer.setDelay(this.timer.getDelay() * 3);
            this.isBoosting = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

