/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.entities;

import com.crihexe.main.GamePanel;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class Snake {
    public static final int TYPE_HEAD = 10;
    public static final int TYPE_BODY = 11;
    public static final int TYPE_TAIL = 12;
    private int x;
    private int y;
    private double d;
    private int type;
    private BufferedImage[] sprites;
    private int l;
    private GamePanel panel;
    public ArrayList<Point> stack;

    public Snake(int x, int y, double d, int type, BufferedImage[] sprites, int l, GamePanel panel) {
        this.x = x;
        this.y = y;
        this.d = d;
        this.type = type;
        this.sprites = sprites;
        this.stack = new ArrayList();
        this.stack.add(new Point(this.x, this.y));
        this.l = l;
        this.panel = panel;
    }

    public void update() throws Exception {
        if (this.d == 1.0) {
            --this.y;
            this.stack.remove(0);
            this.stack.add(new Point(this.x, this.y));
            this.checkDeath();
        } else if (this.d == 2.0) {
            ++this.x;
            this.stack.remove(0);
            this.stack.add(new Point(this.x, this.y));
            this.checkDeath();
        } else if (this.d == 3.0) {
            ++this.y;
            this.stack.remove(0);
            this.stack.add(new Point(this.x, this.y));
            this.checkDeath();
        } else if (this.d == 4.0) {
            --this.x;
            this.stack.remove(0);
            this.stack.add(new Point(this.x, this.y));
            this.checkDeath();
        }
        this.panel.checkEat();
    }

    private void checkDeath() throws Exception {
        int i = this.stack.size() - 1;
        while (i >= this.stack.size() - this.l) {
            if (this.x == this.stack.get((int)i).x && this.y == this.stack.get((int)i).y && i != this.stack.size() - 1) {
                Thread.sleep(500L);
                if (this.panel.isBoosting) {
                    this.panel.rest = true;
                }
                this.panel.init();
            }
            --i;
        }
        if (this.x > 19 || this.x < 0 || this.y < 0 || this.y > 14) {
            Thread.sleep(500L);
            if (this.panel.isBoosting) {
                this.panel.rest = true;
            }
            this.panel.init();
        }
    }

    public void addTail() {
        ++this.l;
        if (this.d == 1.0) {
            this.stack.add(0, new Point(this.stack.get((int)(this.stack.size() - 1)).x, this.stack.get((int)(this.stack.size() - 1)).y + 1));
        }
        if (this.d == 2.0) {
            this.stack.add(0, new Point(this.stack.get((int)(this.stack.size() - 1)).x + 1, this.stack.get((int)(this.stack.size() - 1)).y));
        }
        if (this.d == 3.0) {
            this.stack.add(0, new Point(this.stack.get((int)(this.stack.size() - 1)).x, this.stack.get((int)(this.stack.size() - 1)).y - 1));
        }
        if (this.d == 4.0) {
            this.stack.add(0, new Point(this.stack.get((int)(this.stack.size() - 1)).x - 1, this.stack.get((int)(this.stack.size() - 1)).y));
        }
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.stack.add(new Point(x, y));
    }

    public void setDirection(double d) {
        this.d = d;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setSprite(BufferedImage[] sprites) {
        this.sprites = sprites;
    }

    public void setLength(int l) {
        this.l = l;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double getDirection() {
        return this.d;
    }

    public int getType() {
        return this.type;
    }

    public BufferedImage getSprite() {
        if (this.d == 1.0) {
            return this.sprites[0];
        }
        if (this.d == 2.0) {
            return this.sprites[1];
        }
        if (this.d == 3.0) {
            return this.sprites[2];
        }
        if (this.d == 4.0) {
            return this.sprites[3];
        }
        return null;
    }

    public ArrayList<Point> getStack() {
        return this.stack;
    }

    public int getLength() {
        return this.l;
    }
}

