/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.entities;

import com.crihexe.main.GamePanel;
import com.crihexe.math.Math;
import java.awt.Graphics2D;
import java.util.Random;

public class Star {
    private float x;
    private float y;
    private float z;
    private float pz;
    private GamePanel gp;
    private float speed;
    private Random random;
    private int width;
    private int height;
    private float originalZ;
    private int size;

    public Star(float x, float y, float z, int width, int height, GamePanel gp, Random random) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.gp = gp;
        this.random = random;
        this.pz = z;
        this.originalZ = z;
        if (!gp.getDefaultDirection()) {
            z = 1.0f;
        }
        this.generateSize();
    }

    private void generateSize() {
        this.size = this.random(1, 8);
    }

    public void update() {
        this.speed = this.gp.getSpeed();
        if (this.gp.getDefaultDirection()) {
            this.z -= this.speed;
            if (this.z < 1.0f) {
                this.z = this.width / 2;
                this.x = Math.random(-this.width / 2, this.width / 2, this.random);
                this.y = Math.random(-this.height / 2, this.height / 2, this.random);
                this.pz = this.z;
            }
        } else {
            this.z += this.speed;
            if (this.z > this.originalZ + 100.0f) {
                this.z = 1.0f;
                this.x = Math.random(-this.width / 2, this.width / 2, this.random);
                this.y = Math.random(-this.height / 2, this.height / 2, this.random);
                this.pz = this.z;
            }
        }
    }

    public void draw(Graphics2D g, float nsx, float nsy, float nr, float npx, float npy) {
        float sx = Star.map(this.x / this.z, 0.0f, nsx, 0.0f, this.width / 2);
        float sy = Star.map(this.y / this.z, 0.0f, nsy, 0.0f, this.height / 2);
        float r = Star.map(this.z, 0.0f, nr, 2.0f, 0.0f);
        float px = Star.map(this.x / this.pz, 0.0f, npx, 0.0f, this.width / 2);
        float py = Star.map(this.y / this.pz, 0.0f, npy, 0.0f, this.height / 2);
        this.pz = this.z;
        System.out.println(this.gp.getMode());
        if (this.gp.getMode() == 1) {
            g.fillOval((int)sx, (int)sy, (int)r, (int)r);
            g.drawLine((int)px, (int)py, (int)sx, (int)sy);
        } else if (this.gp.getMode() == 2) {
            sx = Star.map(this.x / this.z, 0.0f, nsx, 0.0f, this.width);
            sy = Star.map(this.y / this.z, 0.0f, nsy, 0.0f, this.height);
            g.fillOval((int)sx, (int)sy, this.size, this.size);
        } else if (this.gp.getMode() == 3) {
            g.fillRect((int)sx, (int)sy, (int)r * 4, (int)r * 4);
            g.drawLine((int)px * 2, (int)py * 2, (int)sx * 2, (int)sy * 2);
            g.drawLine((int)px * 2 - 4, (int)py * 2 - 4, (int)sx * 2, (int)sy * 2);
            g.drawOval((int)sx, (int)sy, (int)r * 4, (int)r * 4);
        }
    }

    private static float map(float value, float start1, float stop1, float start2, float stop2) {
        return (value - start1) / (stop1 - start1) * (stop2 - start2) + start2;
    }

    private int random(int rangeMin, int rangeMax) {
        return Math.randomInt(rangeMin, rangeMax, this.random);
    }

    public void setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }
}

