/*
 * Decompiled with CFR 0.152.
 */
package com.crihexe.main;

import com.crihexe.entities.Star;
import com.crihexe.math.Math;
import com.crihexe.objects.FSlider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 600;
    private static final int HEIGHT = 600;
    private int FPS = 60;
    private int targetTime = this.FPS / 1000;
    private boolean running;
    private BufferedImage image;
    private Graphics2D g;
    private Thread thread;
    private Star[] stars;
    private boolean defaultDirection;
    private int mx;
    private int my;
    private Random random;
    private boolean isStopped;
    private float speed;
    private boolean isInverted;
    private int mode;
    private boolean isScreenshot;
    private float sx;
    private float sy;
    private float r;
    private float px;
    private float py;

    public GamePanel() {
        this.setPreferredSize(new Dimension(600, 600));
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(true);
        this.addNotifify();
    }

    private void addNotifify() {
        this.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        try {
            this.init();
            Thread.sleep(500L);
            while (this.running) {
                long start = System.nanoTime();
                if (!this.isStopped) {
                    this.update();
                }
                this.draw();
                this.drawToScreen();
                long elapsed = System.nanoTime() - start;
                long wait = (long)this.targetTime - elapsed / 1000000L;
                if (wait <= 0L) {
                    wait = 5L;
                }
                Thread.sleep(wait);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.image = new BufferedImage(600, 600, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.random = new Random();
        this.isStopped = false;
        this.mode = 1;
        this.buildDefaultStars();
        this.showHelpFrame();
        this.g.translate(300, 300);
        this.isScreenshot = false;
        this.speed = 4.5f;
        this.buildGraphicsDistorter();
        this.running = true;
    }

    private void buildGraphicsDistorter() {
        DecimalFormat df = new DecimalFormat("0.####");
        JFrame frame = new JFrame("Distorser Control Panel - By Crih.exe");
        frame.setLayout(null);
        this.sx = 1.0f;
        this.sy = 1.0f;
        this.px = 1.0f;
        this.py = 1.0f;
        this.buildSX(frame, df);
        this.buildSY(frame, df);
        this.buildPX(frame, df);
        this.buildPY(frame, df);
        this.r = 300.0f;
        frame.setBounds(800, 200, 420, 300);
        frame.setResizable(false);
        frame.setDefaultCloseOperation(0);
        frame.setVisible(true);
    }

    private void buildSX(JFrame frame, final DecimalFormat df) {
        final JTextField text = new JTextField(20);
        final FSlider slider = new FSlider(1, 500, 10, 10);
        text.setBounds(0, 0, 250, 20);
        slider.setBounds(0, 20, 400, 20);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                text.setText(df.format(slider.getScaledValue()));
                System.out.println(df.format(slider.getScaledValue()));
                GamePanel.this.sx = (float)Double.parseDouble(df.format(slider.getScaledValue()).replace(",", "."));
            }
        });
        text.setText(df.format(slider.getScaledValue()));
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                String typed = text.getText();
                slider.setValue(0);
                if (!typed.matches("\\d+(\\.\\d*)?")) {
                    return;
                }
                double value = Double.parseDouble(typed) * (double)slider.scale;
                slider.setValue((int)value);
                GamePanel.this.sx = Float.parseFloat(df.format(slider.getScaledValue()).replace(",", "."));
            }
        });
        frame.add(text);
        frame.add(slider);
    }

    private void buildSY(JFrame frame, final DecimalFormat df) {
        final JTextField text = new JTextField(20);
        final FSlider slider = new FSlider(1, 500, 10, 10);
        text.setBounds(0, 50, 250, 20);
        slider.setBounds(0, 70, 400, 20);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                text.setText(df.format(slider.getScaledValue()));
                GamePanel.this.sy = Float.parseFloat(df.format(slider.getScaledValue()).replace(",", "."));
            }
        });
        text.setText(df.format(slider.getScaledValue()));
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                String typed = text.getText();
                slider.setValue(0);
                if (!typed.matches("\\d+(\\.\\d*)?")) {
                    return;
                }
                double value = Double.parseDouble(typed) * (double)slider.scale;
                slider.setValue((int)value);
                GamePanel.this.sy = Float.parseFloat(df.format(slider.getScaledValue()).replace(",", "."));
            }
        });
        frame.add(text);
        frame.add(slider);
    }

    private void buildPX(JFrame frame, final DecimalFormat df) {
        final JTextField text = new JTextField(20);
        final FSlider slider = new FSlider(1, 500, 10, 10);
        text.setBounds(0, 100, 250, 20);
        slider.setBounds(0, 120, 400, 20);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                text.setText(df.format(slider.getScaledValue()));
                GamePanel.this.px = Float.parseFloat(df.format(slider.getScaledValue()).replace(",", "."));
            }
        });
        text.setText(df.format(slider.getScaledValue()));
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                String typed = text.getText();
                slider.setValue(0);
                if (!typed.matches("\\d+(\\.\\d*)?")) {
                    return;
                }
                double value = Double.parseDouble(typed) * (double)slider.scale;
                slider.setValue((int)value);
                GamePanel.this.px = Float.parseFloat(df.format(slider.getScaledValue()).replace(",", "."));
            }
        });
        frame.add(text);
        frame.add(slider);
    }

    private void buildPY(JFrame frame, final DecimalFormat df) {
        final JTextField text = new JTextField(20);
        final FSlider slider = new FSlider(1, 500, 10, 10);
        text.setBounds(0, 150, 250, 20);
        slider.setBounds(0, 170, 400, 20);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                text.setText(df.format(slider.getScaledValue()));
                GamePanel.this.py = Float.parseFloat(df.format(slider.getScaledValue()).replace(",", "."));
            }
        });
        text.setText(df.format(slider.getScaledValue()));
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                String typed = text.getText();
                slider.setValue(0);
                if (!typed.matches("\\d+(\\.\\d*)?")) {
                    return;
                }
                double value = Double.parseDouble(typed) * (double)slider.scale;
                slider.setValue((int)value);
                GamePanel.this.py = Float.parseFloat(df.format(slider.getScaledValue()).replace(",", "."));
            }
        });
        frame.add(text);
        frame.add(slider);
    }

    private void buildDefaultStars() {
        this.stars = new Star[1200];
        int i = 0;
        while (i < this.stars.length) {
            float x = Math.random(-300.0f, 300.0f, this.random);
            float y = Math.random(-300.0f, 300.0f, this.random);
            float z = Math.random(0.0f, 300.0f, this.random);
            this.stars[i] = new Star(x, y, z, 600, 600, this, this.random);
            ++i;
        }
    }

    private void update() {
        int i = 0;
        while (i < this.stars.length) {
            this.stars[i].update();
            ++i;
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    private void draw() {
        this.refresh();
        this.drawStars();
        if (this.isScreenshot) {
            this.screenshot();
        }
        if (!this.isInverted) {
            this.g.setColor(Color.white);
        } else {
            this.g.setColor(Color.black);
        }
        if (!this.isScreenshot) {
            this.g.drawString("Velocity: " + this.speed, this.mx, this.my);
        }
    }

    private void refresh() {
        Color c = this.g.getColor();
        if (!this.isInverted) {
            this.g.setColor(Color.black);
        } else {
            this.g.setColor(Color.white);
        }
        this.g.fillRect(-600, -600, 1200, 1200);
        this.g.setColor(c);
    }

    private void drawStars() {
        if (!this.isInverted) {
            this.g.setColor(Color.white);
        } else {
            this.g.setColor(Color.black);
        }
        int i = 0;
        while (i < this.stars.length) {
            this.stars[i].draw(this.g, this.sx, this.sy, this.r, this.px, this.py);
            ++i;
        }
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, 600, 600, null);
        g2.dispose();
    }

    private void stop() {
        this.isStopped = true;
    }

    private void changeAmount() {
        int newAmount = this.getNewAmount();
        if (newAmount != -1) {
            this.stars = new Star[newAmount];
            int i = 0;
            while (i < this.stars.length) {
                float x = Math.random(-300.0f, 300.0f, this.random);
                float y = Math.random(-300.0f, 300.0f, this.random);
                float z = Math.random(0.0f, 300.0f, this.random);
                this.stars[i] = new Star(x, y, z, 600, 600, this, this.random);
                ++i;
            }
        }
    }

    private int getNewAmount() {
        JPanel panel = new JPanel();
        ArrayList<Integer> arr = new ArrayList<Integer>();
        int i = 200;
        while (i < 12200) {
            arr.add(i);
            i += 200;
        }
        String[] array = new String[arr.size()];
        int i2 = 0;
        while (i2 < array.length) {
            array[i2] = "" + arr.get(i2);
            ++i2;
        }
        JComboBox<String> combobox = new JComboBox<String>(array);
        combobox.setSelectedIndex(5);
        panel.add(new JLabel("Seleziona il numero di stelle: "));
        panel.add(combobox);
        int result = JOptionPane.showConfirmDialog(null, panel, "Seleziona n. di stelle. Default = 1200", 2);
        if (result == 0) {
            return Integer.parseInt(combobox.getSelectedItem().toString());
        }
        return -1;
    }

    private void resume() {
        this.isStopped = false;
    }

    private void showHelpFrame() {
        JFrame frame = new JFrame("Comandi");
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JLabel label1 = new JLabel("Freccia a destra: Aumenta velocit\u00e0");
        label1.setBounds(2, 2, 500, 10);
        panel.add(label1);
        JLabel label2 = new JLabel("Freccia a sinistra: Diminuisce velocit\u00e0");
        label2.setBounds(2, 12, 500, 10);
        panel.add(label2);
        JLabel label3 = new JLabel("Backspace (cancella): Cambia quantit\u00e0");
        label3.setBounds(2, 22, 500, 10);
        panel.add(label3);
        JLabel label4 = new JLabel("Spazio: Mette in pausa/fa ripartire");
        label4.setBounds(2, 32, 500, 10);
        panel.add(label4);
        JLabel label9 = new JLabel("Freccia su: Aumenta modalit\u00e0");
        label9.setBounds(2, 72, 500, 10);
        panel.add(label9);
        frame.add(panel);
        JLabel label10 = new JLabel("Freccia gi\u00f9: Torna alla modalit\u00e0 precedente");
        label10.setBounds(2, 82, 500, 10);
        panel.add(label10);
        frame.add(panel);
        JLabel label5 = new JLabel("Invio o s: Screenshot nella cartella immagini dell'utente");
        label5.setBounds(2, 42, 500, 10);
        panel.add(label5);
        JLabel label6 = new JLabel("Q: Invertiti colori");
        label6.setBounds(2, 52, 500, 10);
        panel.add(label6);
        JLabel label7 = new JLabel("D: Cambia direzione");
        label7.setBounds(2, 62, 500, 10);
        panel.add(label7);
        JLabel label8 = new JLabel("H: Mostra questa finestra");
        label8.setBounds(2, 102, 500, 10);
        panel.add(label8);
        frame.add(panel);
        frame.setBounds(300, 300, 340, 155);
        frame.setResizable(false);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    @Override
    public String getName() {
        return "Screenshot_" + new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss").format(new Date()) + ".jpg";
    }

    private void screenshot() {
        File screenshot = new File(String.valueOf(System.getProperty("user.home")) + "\\Pictures\\Visualizzatore_Grafico_Crihexe\\" + this.getName());
        try {
            if (!new File(screenshot.getParent()).exists()) {
                new File(screenshot.getParent()).mkdir();
            }
            ImageIO.write((RenderedImage)this.image, "jpg", screenshot);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.isScreenshot = false;
    }

    public boolean getDefaultDirection() {
        return this.defaultDirection;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 39) {
            this.speed += 0.5f;
        }
        if (e.getKeyCode() == 37) {
            this.speed -= 0.5f;
            if (this.speed <= 0.0f) {
                this.speed = 0.5f;
            }
        }
        if (e.getKeyCode() == 8) {
            this.stop();
            this.changeAmount();
            this.resume();
        }
        if (e.getKeyCode() == 32) {
            if (!this.isStopped) {
                this.stop();
            } else if (this.isStopped) {
                this.resume();
            }
        }
        if (e.getKeyCode() == 10 || e.getKeyCode() == 83) {
            this.isScreenshot = true;
        }
        if (e.getKeyCode() == 81) {
            this.isInverted = !this.isInverted;
        }
        if (e.getKeyCode() == 68) {
            this.defaultDirection = !this.defaultDirection;
        }
        if (e.getKeyCode() == 72) {
            this.showHelpFrame();
        }
        if (e.getKeyCode() == 38) {
            ++this.mode;
            if (this.mode > 3) {
                this.mode = 1;
            }
        } else if (e.getKeyCode() == 40) {
            --this.mode;
            if (this.mode < 1) {
                this.mode = 3;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mx = e.getX() - 300;
        this.my = e.getY() - 300 - 3;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

