/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import main.Main;
import main.VersionPanel;

public class FramePanel
extends JPanel
implements KeyListener {
    private Color fontColor = new Color(0, 0, 0);
    private Font font = new Font("Calibri", 0, 24);
    private int currentSelection;
    private boolean isDownloading = false;
    private String[] playSettings = new String[]{"Gioca l'ultima versione", "Versioni"};

    public FramePanel() {
        this.setPreferredSize(new Dimension(1024, 512));
        this.setFocusable(true);
        this.addKeyListener(this);
        this.currentSelection = 0;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            --this.currentSelection;
            if (this.currentSelection < 0) {
                this.currentSelection = this.playSettings.length - 1;
            }
        }
        if (e.getKeyCode() == 40) {
            ++this.currentSelection;
            if (this.currentSelection > this.playSettings.length) {
                this.currentSelection = 0;
            }
        }
        if (e.getKeyCode() == 10) {
            if (this.currentSelection == 0) {
                System.out.println("Download in corso...");
                this.isDownloading = true;
            } else if (this.currentSelection == 1) {
                VersionPanel.main(null);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setFont(this.font);
        g.setColor(this.fontColor);
        g.drawString(this.playSettings[0], 375, 150);
        g.drawString(this.playSettings[1], 435, 200);
        if (this.currentSelection == 0) {
            g.setColor(Color.RED);
            g.drawString(this.playSettings[0], 375, 150);
        } else if (this.currentSelection == 1) {
            g.setColor(Color.RED);
            g.drawString(this.playSettings[1], 435, 200);
        }
        if (this.isDownloading) {
            g.setColor(Color.RED);
            g.drawString("Verifica ed eventuale download in corso... Attendi", 250, 300);
            Timer timer = new Timer(1000, e -> Main.connect(1));
            timer.setRepeats(false);
            timer.start();
        }
        this.repaint();
    }
}

