/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import launcherState.LauncherStateManager;

public class LauncherPanel
extends JPanel
implements Runnable,
KeyListener {
    public static final int WIDTH = 768;
    public static final int HEIGHT = 512;
    public static Thread thread;
    private boolean running;
    private int FPS = 60;
    private long targetTime = this.FPS / 1000;
    private BufferedImage image;
    private Graphics2D g;
    private LauncherStateManager lsm;

    public LauncherPanel() {
        this.setPreferredSize(new Dimension(768, 512));
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addNotifify();
    }

    public void addNotifify() {
        super.addNotify();
        if (thread == null) {
            thread = new Thread(this);
            thread.start();
        }
    }

    private void init() {
        this.image = new BufferedImage(768, 512, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.running = true;
        this.lsm = new LauncherStateManager();
    }

    @Override
    public void run() {
        this.init();
        while (this.running) {
            long start = System.nanoTime();
            this.update();
            this.draw();
            this.drawToScreen();
            long elapsed = System.nanoTime() - start;
            long wait = this.targetTime - elapsed / 1000000L;
            if (wait <= 0L) {
                wait = 5L;
            }
            try {
                Thread.sleep(wait);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void update() {
        this.lsm.update();
    }

    private void draw() {
        this.lsm.draw(this.g);
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, null);
        g2.dispose();
    }

    @Override
    public void keyTyped(KeyEvent key) {
    }

    @Override
    public void keyPressed(KeyEvent key) {
        this.lsm.keyPressed(key.getKeyCode());
    }

    @Override
    public void keyReleased(KeyEvent key) {
        this.lsm.keyReleased(key.getKeyCode());
    }

    public static void restart() {
        thread.stop();
    }
}

