/*
 * Decompiled with CFR 0.152.
 */
package GameState.w1;

import Entity.Enemies.Slugger;
import Entity.Enemy;
import Entity.Explosion;
import Entity.HUD;
import Entity.Player;
import GameState.GameState;
import GameState.GameStateManager;
import GameState.MenuState;
import TileMap.Background;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import main.menuOptions.Settings;
import main.menuOptions.settingsOptions.ChangeCommands;

public class Level1State
extends GameState {
    private TileMap tileMap;
    private Background bg;
    private Player player;
    private ArrayList<Enemy> enemies;
    private ArrayList<Explosion> explosions;
    private HUD hud;

    public Level1State(GameStateManager gsm) {
        super(gsm);
    }

    @Override
    public void init() {
        this.tileMap = new TileMap(32);
        this.tileMap.loadTiles("/Tilesets/grasstileset.png");
        this.tileMap.loadMap("/Maps/level1-1.map");
        this.tileMap.setPosition(0.0, 0.0);
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/planet.png") : new Background("/Backgrounds/error.jpg"));
        this.player = new Player(this.tileMap);
        this.player.setPosition(100.0, 100.0);
        this.creaNemici();
        this.explosions = new ArrayList();
        this.hud = new HUD(this.player);
    }

    private void creaNemici() {
        this.enemies = new ArrayList();
        Point[] points = new Point[]{new Point(200, 100), new Point(860, 200), new Point(1680, 200), new Point(1800, 200), new Point(1980, 200)};
        int i = 0;
        while (i < points.length) {
            Slugger s = new Slugger(this.tileMap);
            s.setPosition(points[i].x, points[i].y);
            this.enemies.add(s);
            ++i;
        }
    }

    @Override
    protected void update() {
        this.player.update();
        this.tileMap.setPosition(256 - this.player.getx(), 128 - this.player.gety());
        this.player.checkAttack(this.enemies);
        int i = 0;
        while (i < this.enemies.size()) {
            Enemy e = this.enemies.get(i);
            e.update();
            if (e.isDead()) {
                this.enemies.remove(i);
                --i;
                this.explosions.add(new Explosion(e.getx(), e.gety()));
            }
            ++i;
        }
        i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).update();
            if (this.explosions.get(i).shouldRemove()) {
                this.explosions.remove(i);
                --i;
            }
            ++i;
        }
    }

    @Override
    protected void draw(Graphics2D g) {
        this.bg.draw(g);
        this.tileMap.draw(g);
        this.player.draw(g);
        int i = 0;
        while (i < this.enemies.size()) {
            this.enemies.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).setMapPosition(this.tileMap.getx(), this.tileMap.gety());
            this.explosions.get(i).draw(g);
            ++i;
        }
        this.hud.draw(g);
    }

    @Override
    protected void keyPressed(int k) {
        if (k == ChangeCommands.commands[1]) {
            this.player.setLeft(true);
        }
        if (k == ChangeCommands.commands[0]) {
            this.player.setRight(true);
        }
        if (k == ChangeCommands.commands[3]) {
            this.player.setUp(true);
        }
        if (k == ChangeCommands.commands[4]) {
            this.player.setDown(true);
        }
        if (k == ChangeCommands.commands[2]) {
            this.player.setJumping(true);
        }
        if (k == ChangeCommands.commands[5]) {
            this.player.setGliding(true);
        }
        if (k == ChangeCommands.commands[6]) {
            this.player.setPunching();
        }
        if (k == ChangeCommands.commands[7]) {
            this.player.setDonuting();
        }
        if (k == 27) {
            this.gsm.states.push(new MenuState(this.gsm));
        }
    }

    @Override
    protected void keyReleased(int k) {
        if (k == ChangeCommands.commands[1]) {
            this.player.setLeft(false);
        }
        if (k == ChangeCommands.commands[0]) {
            this.player.setRight(false);
        }
        if (k == ChangeCommands.commands[3]) {
            this.player.setUp(false);
        }
        if (k == ChangeCommands.commands[4]) {
            this.player.setDown(false);
        }
        if (k == ChangeCommands.commands[2]) {
            this.player.setJumping(false);
        }
        if (k == ChangeCommands.commands[5]) {
            this.player.setGliding(false);
        }
    }
}

