/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.Enemies.Carrot;
import Entity.Enemy;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Brocky
extends Enemy {
    private BufferedImage[] sprites;
    private int carrotDamage;
    private boolean carroting;
    private ArrayList<Carrot> carrotC;

    public Brocky(TileMap tm) {
        super(tm);
        this.moveSpeed = 0.05;
        this.maxSpeed = 0.05;
        this.fallSpeed = 0.2;
        this.maxFallSpeed = 10.0;
        this.width = 20;
        this.height = 20;
        this.cwidth = 20;
        this.cheight = 20;
        this.maxHealth = 10;
        this.health = 10;
        this.damage = 2;
        this.carrotDamage = 2;
        this.carrotC = new ArrayList();
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/brocky.gif"));
            this.sprites = new BufferedImage[3];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spritesheet.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.animation.setFrames(this.sprites);
        this.animation.setDelay(300L);
        this.right = true;
        this.facingRight = true;
    }

    public void setCarroting() {
        this.carroting = true;
    }

    private void getNextPosition() {
        if (this.falling) {
            this.dy += this.fallSpeed;
        }
    }

    @Override
    public void update() {
        long elapsed;
        this.getNextPosition();
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.flinching && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) > 400L) {
            this.flinching = false;
        }
        this.animation.update();
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        int i = 0;
        while (i < this.carrotC.size()) {
            this.carrotC.get(i).draw(g);
            ++i;
        }
        super.draw(g);
    }
}

