/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.Enemies.Brocky;
import Entity.MapObject;
import Entity.Player;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Carrot
extends MapObject {
    private boolean hit;
    private boolean remove;
    private BufferedImage[] sprites;
    private BufferedImage[] hitSprites;
    private Brocky brock1;
    private Brocky brock2;
    private Player me;
    private int ipo;

    public Carrot(TileMap tm, boolean right) {
        super(tm);
        int y;
        int x;
        this.brock1 = new Brocky(tm);
        this.brock2 = new Brocky(tm);
        this.me = new Player(tm);
        this.facingRight = right;
        this.moveSpeed = 1.2;
        if (right) {
            x = this.me.getx() - this.brock1.getx();
            y = this.me.gety() - this.brock1.gety();
            this.ipo = (int)Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        } else {
            x = this.brock1.gety() - this.me.gety();
            y = this.brock1.gety() - this.me.getY();
            this.ipo = (int)Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        }
        this.width = 30;
        this.height = 30;
        this.cwidth = 14;
        this.cheight = 14;
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/carrot.gif"));
            this.sprites = new BufferedImage[4];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spritesheet.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
            this.hitSprites = new BufferedImage[3];
            i = 0;
            while (i < this.hitSprites.length) {
                this.hitSprites[i] = spritesheet.getSubimage(i * this.width, this.height, this.width, this.height);
                ++i;
            }
            this.animation = new Animation();
            this.animation.setFrames(this.sprites);
            this.animation.setDelay(100L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setHit() {
        if (this.hit) {
            return;
        }
        this.hit = true;
        this.animation.setFrames(this.hitSprites);
        this.animation.setDelay(45L);
        this.dx = 0.0;
        this.dy = 0.0;
    }

    public boolean shouldRemove() {
        return this.remove;
    }

    public void update() {
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.dx == 0.0 && !this.hit) {
            this.setHit();
        }
        this.animation.update();
        if (this.hit && this.animation.hasPlayedOnce()) {
            this.remove = true;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        super.draw(g);
    }
}

