/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.MapObject;
import Entity.Player;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Carrot
extends MapObject {
    float dx;
    float dy;
    private boolean hit;
    private boolean remove;
    private BufferedImage[] sprites;
    private BufferedImage[] hitSprites;

    public Carrot(TileMap tm, Player player) {
        super(tm);
        this.facingRight = this.right;
        this.moveSpeed = 1.2;
        this.width = 30;
        this.height = 30;
        this.cwidth = 14;
        this.cheight = 14;
        try {
            BufferedImage spriteS = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/carrot.gif"));
            this.sprites = new BufferedImage[2];
            int i = 1;
            while (i < this.sprites.length) {
                this.sprites[i] = spriteS.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
            this.animation = new Animation();
            this.animation.setFrames(this.sprites);
            this.animation.setDelay(100L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dx = (float)((double)player.getX() - this.x);
        this.dy = (float)((double)player.getY() - this.y);
        float dist = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.dx /= dist;
        this.dy /= dist;
        this.dx = (float)((double)this.dx * 1.2);
        this.dy = (float)((double)this.dy * 1.2);
    }

    public void update() {
        this.x += (double)this.dx;
        this.y += (double)this.dy;
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.dx == 0.0f && !this.hit) {
            this.setHit();
        }
        this.animation.update();
        if (this.hit && this.animation.hasPlayedOnce()) {
            this.remove = true;
        }
    }

    public void setHit() {
        if (this.hit) {
            return;
        }
        this.hit = true;
        this.animation.setFrames(this.hitSprites);
        this.animation.setDelay(45L);
        this.dx = 0.0f;
        this.dy = 0.0f;
    }

    public boolean shouldRemove() {
        return this.remove;
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        if (this.facingRight) {
            g.drawImage((Image)this.animation.getImage(), (int)(this.x + this.xmap - (double)(this.width / 2)), (int)(this.y + this.ymap - (double)(this.height / 2)), null);
            System.out.println(String.valueOf((int)(this.x + this.xmap - (double)(this.width / 2))) + " - " + (int)(this.y + this.ymap - (double)(this.height / 2)));
        } else {
            System.out.println(String.valueOf((int)(this.x + this.xmap - (double)(this.width / 2) + (double)this.width)) + " - " + (int)(this.y + this.ymap - (double)(this.height / 2)) + "        " + -this.width + " - " + this.height);
            g.drawImage(this.animation.getImage(), (int)(this.x + this.xmap - (double)(this.width / 2) + (double)this.width), (int)(this.y + this.ymap - (double)(this.height / 2)), -this.width, this.height, null);
        }
    }
}

