/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import GameState.DeathSceneState;
import GameState.GameState;
import GameState.MenuState;
import GameState.w1.Level1State;
import java.awt.Graphics2D;

public class GameStateManager {
    public GameState[] states = new GameState[3];
    private int currentState = 0;
    public static final int NUMGAMESTATES = 3;
    public static final int MENUSTATE = 0;
    public static final int LEVEL1STATE = 1;
    public static final int DEATHSCENE = 2;

    public GameStateManager() {
        this.loadState(this.currentState);
        if (this.currentState == 743932) {
            System.exit(0);
        }
    }

    private void loadState(int state) {
        if (state == 0) {
            this.states[state] = new MenuState(this);
        }
        if (state == 1) {
            this.states[state] = new Level1State(this);
        }
        if (state == 2) {
            this.states[state] = new DeathSceneState(this);
        }
    }

    public void unloadState(int state) {
        this.states[state] = null;
    }

    public void setState(int state) {
        this.unloadState(this.currentState);
        this.currentState = state;
        this.loadState(this.currentState);
    }

    public void update() {
        try {
            this.states[this.currentState].update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void draw(Graphics2D g) {
        try {
            this.states[this.currentState].draw(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(int k) {
        try {
            this.states[this.currentState].keyPressed(k);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void keyReleased(int k) {
        try {
            this.states[this.currentState].keyReleased(k);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

