/*
 * Decompiled with CFR 0.152.
 */
package Audio;

import GameState.SoundOptions;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public class AudioPlayer {
    private Clip clip;
    private SoundOptions so;

    public AudioPlayer(String s) {
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(this.getClass().getResourceAsStream(s));
            AudioFormat baseFormat = ais.getFormat();
            AudioFormat decodeFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
            AudioInputStream dais = AudioSystem.getAudioInputStream(decodeFormat, ais);
            this.clip = AudioSystem.getClip();
            this.clip.open(dais);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play() {
        if (this.clip == null) {
            return;
        }
        this.stop();
        this.clip.setFramePosition(0);
        this.clip.start();
    }

    public void stop() {
        if (this.clip.isRunning()) {
            this.clip.stop();
        }
    }

    public void close() {
        this.stop();
        this.clip.close();
    }
}

