/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.Enemies.Carrot;
import Entity.Enemy;
import Entity.Player;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class Brocky
extends Enemy {
    private BufferedImage[] sprites;
    private static final long THROW_INTERVAL = 5000L;
    private long lastThrowTime;
    private Player player;

    public Brocky(TileMap tm, Player player) {
        super(tm);
        this.player = player;
        this.moveSpeed = 0.05;
        this.maxSpeed = 0.05;
        this.width = 20;
        this.height = 20;
        this.cwidth = 20;
        this.cheight = 20;
        this.maxHealth = 10;
        this.health = 10;
        this.damage = 2;
        this.fallSpeed = 1.2;
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/brocky.gif"));
            this.sprites = new BufferedImage[3];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spritesheet.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.animation.setFrames(this.sprites);
        this.animation.setDelay(300L);
        this.right = true;
        this.facingRight = true;
    }

    private void getNextPosition() {
        if (this.falling) {
            this.dy += this.fallSpeed;
        }
    }

    @Override
    public void update() {
        long elapsed;
        this.getNextPosition();
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.flinching && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) > 400L) {
            this.flinching = false;
        }
        if (this.canThrowCarrot()) {
            this.throwCarrot();
        }
        this.animation.update();
    }

    private boolean canThrowCarrot() {
        boolean throwC = true;
        long timeSinceLastThrow = System.currentTimeMillis() - this.lastThrowTime;
        if (timeSinceLastThrow < 5000L) {
            throwC = false;
        }
        return throwC;
    }

    private void throwCarrot() {
        this.lastThrowTime = System.currentTimeMillis();
        new Carrot(this.tileMap, this.player);
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        super.draw(g);
    }
}

