/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import GameState.GameState;
import GameState.GameStateManager;
import TileMap.Background;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import main.Game;
import main.menuOptions.Help;
import main.menuOptions.Settings;

public class MenuState
extends GameState {
    private Font SPB;
    private Background bg;
    private int currentSelection = 0;
    private String[] options = new String[]{"Inizio", "Comandi", "Impostazioni", "Audio", "Esci"};
    private Color titleColor;
    private Font titleFont;
    private Font font;

    public MenuState(GameStateManager gsm) {
        super(gsm);
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/cave.png") : new Background("/Backgrounds/error.jpg"));
        this.titleColor = new Color(100, 0, 100);
        this.titleFont = new Font("Calibri", 0, 48);
        this.font = new Font("Calibri", 1, 28);
    }

    @Override
    public void init() {
    }

    @Override
    protected void update() {
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/cave.png") : new Background("/Backgrounds/error.jpg"));
        this.bg.update();
    }

    @Override
    protected void draw(Graphics2D g) {
        this.bg.draw(g);
        g.setColor(this.titleColor);
        g.setFont(this.titleFont);
        g.drawString("Super Pierlu Bros", 85, 64);
        g.setFont(this.font);
        int i = 0;
        while (i < this.options.length) {
            if (i == this.currentSelection) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.RED);
            }
            g.drawString(this.options[i], 87, 108 + i * 30);
            ++i;
        }
    }

    @Override
    protected void keyPressed(int k) {
        if (k == 40) {
            ++this.currentSelection;
            if (this.currentSelection >= this.options.length) {
                this.currentSelection = 0;
            }
        } else if (k == 38) {
            --this.currentSelection;
            if (this.currentSelection < 0) {
                this.currentSelection = this.options.length - 1;
            }
        }
        if (k == 10) {
            if (this.currentSelection == 0) {
                this.gsm.setState(1);
            } else if (this.currentSelection == 1) {
                Help.main(null);
                Game.window.setEnabled(false);
            } else if (this.currentSelection == 2) {
                Settings.main(null);
                Game.window.setEnabled(false);
            } else if (this.currentSelection == 3) {
                this.gsm.setState(4);
            } else if (this.currentSelection == 4) {
                System.exit(0);
            }
        }
    }

    @Override
    protected void keyReleased(int k) {
    }
}

