/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.Enemies.Carrot;
import Entity.Enemy;
import Entity.Player;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Brocky
extends Enemy {
    private BufferedImage[] sprites;
    private ArrayList<Enemy> enemies;
    private ArrayList<Carrot> carrotC;
    private int carrotDamage;
    private boolean carroting;
    private static final int IDLE = 0;
    private static final int CARROTING = 1;
    private static final long THROW_INTERVAL = 5000L;
    private long lastThrowTime;
    private Player player;

    public Brocky(TileMap tm, Player player) {
        super(tm);
        this.player = player;
        this.moveSpeed = 0.05;
        this.maxSpeed = 0.05;
        this.width = 20;
        this.height = 20;
        this.cwidth = 20;
        this.cheight = 20;
        this.maxHealth = 10;
        this.health = 10;
        this.damage = 2;
        this.carrotDamage = 1;
        this.carrotC = new ArrayList();
        this.fallSpeed = 1.2;
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/brocky.gif"));
            this.sprites = new BufferedImage[3];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spritesheet.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.animation.setFrames(this.sprites);
        this.animation.setDelay(300L);
        this.right = true;
        this.facingRight = true;
    }

    private void getNextPosition() {
        if (this.falling) {
            this.dy += this.fallSpeed;
        }
    }

    public void setCarroting() {
        this.carroting = true;
    }

    public int getX() {
        return (int)(this.x + this.xmap - (double)(this.width / 2));
    }

    public int getY() {
        return (int)(this.y + this.ymap - (double)(this.height / 2));
    }

    public void checkAttack(ArrayList<Player> player) {
        int i = 0;
        while (i < player.size()) {
            Player p = player.get(i);
            int j = 0;
            while (j < this.carrotC.size()) {
                if (this.carrotC.get(j).intersets(this.enemies.get(i))) {
                    p.hit(this.carrotDamage);
                    this.carrotC.get(j).setHit();
                    break;
                }
                ++j;
            }
            if (this.intersets(p)) {
                this.hit(1);
            }
            ++i;
        }
    }

    @Override
    public void update() {
        long elapsed;
        this.getNextPosition();
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.flinching && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) > 400L) {
            this.flinching = false;
        }
        if (this.currentAction == 1 && this.animation.hasPlayedOnce()) {
            this.carroting = false;
        }
        if (this.carroting && this.currentAction != 1) {
            Carrot cc = new Carrot(this.tileMap, this.facingRight);
            cc.setPosition(this.x, this.y);
            this.carrotC.add(cc);
        }
        int i = 0;
        while (i < this.carrotC.size()) {
            this.carrotC.get(i).update();
            if (this.carrotC.get(i).shouldRemove()) {
                this.carrotC.remove(i);
                --i;
            }
            ++i;
        }
        if (this.carroting && this.currentAction != 1) {
            this.currentAction = 1;
            this.animation.setFrames(new BufferedImage[0]);
            this.animation.setDelay(60L);
            this.width = 30;
        }
        if (this.canThrowCarrot()) {
            System.out.println("N");
            this.throwCarrot();
        }
        this.animation.update();
    }

    public boolean canThrowCarrot() {
        boolean lancia = true;
        long timeSinceLastThrow = System.currentTimeMillis() - this.lastThrowTime;
        if (timeSinceLastThrow < 5000L) {
            lancia = false;
        }
        return lancia;
    }

    private void throwCarrot() {
        this.lastThrowTime = System.currentTimeMillis();
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        super.draw(g);
    }
}

