/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.MapObject;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Carrot
extends MapObject {
    private boolean hit;
    private boolean remove;
    private BufferedImage[] sprites;
    private BufferedImage[] hitSprites;

    public Carrot(TileMap tm, boolean right) {
        super(tm);
        this.facingRight = right;
        this.moveSpeed = 2.2;
        this.dx = right ? this.moveSpeed : -this.moveSpeed;
        this.width = 30;
        this.height = 30;
        this.cwidth = 14;
        this.cheight = 14;
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/carrot.gif"));
            this.sprites = new BufferedImage[4];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spritesheet.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
            this.hitSprites = new BufferedImage[3];
            i = 0;
            while (i < this.hitSprites.length) {
                this.hitSprites[i] = spritesheet.getSubimage(i * this.width, this.height, this.width, this.height);
                ++i;
            }
            this.animation = new Animation();
            this.animation.setFrames(this.sprites);
            this.animation.setDelay(100L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setHit() {
        if (this.hit) {
            return;
        }
        this.hit = true;
        this.animation.setFrames(this.hitSprites);
        this.animation.setDelay(45L);
        this.dx = 0.0;
    }

    public boolean shouldRemove() {
        return this.remove;
    }

    public void update() {
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.dx == 0.0 && !this.hit) {
            this.setHit();
        }
        this.animation.update();
        if (this.hit && this.animation.hasPlayedOnce()) {
            this.remove = true;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        super.draw(g);
    }
}

