/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.Animation;
import GameState.GameState;
import GameState.GameStateManager;
import TileMap.Background;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.Timer;
import main.menuOptions.Settings;

public class LoadingScreen
extends GameState {
    private Background bg;
    private BufferedImage[] sprites;
    private Animation animation;
    private int newState;

    public LoadingScreen(GameStateManager gsm, int state) {
        super(gsm);
        this.newState = state;
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/cave.png") : new Background("/Backgrounds/error.jpg"));
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Backgrounds/loading.png"));
            this.sprites = new BufferedImage[3];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spritesheet.getSubimage(i * 512, 0, 512, 256);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.animation.setFrames(this.sprites);
        this.animation.setDelay(200L);
    }

    @Override
    public void init() {
    }

    @Override
    protected void update() {
        this.bg.update();
        this.animation.update();
        Timer timer = new Timer(1200, e -> {
            this.gsm.currentState = this.newState;
            this.gsm.setState(this.newState, this.newState);
        });
        timer.setRepeats(false);
        timer.start();
    }

    @Override
    protected void draw(Graphics2D g) {
        this.bg.draw(g);
        g.drawImage((Image)this.animation.getImage(), 0, 0, null);
        g.setFont(new Font("Consolas", 0, 12));
        g.setColor(Color.WHITE);
        g.drawString("Il tuo PC potrebbe impiegare un p\u00f2 di tempo a caricare", 2, 245);
    }

    @Override
    protected void keyPressed(int k) {
    }

    @Override
    protected void keyReleased(int k) {
    }
}

