/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Entity.Animation;
import Entity.DonutC;
import Entity.Enemy;
import Entity.MapObject;
import GameState.GameStateManager;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Player
extends MapObject {
    private int health;
    private int maxHealth;
    private int donut;
    private int maxDonut;
    private boolean dead;
    private boolean flinching;
    private long flinchTimer;
    private boolean donuting;
    private int donutCost;
    private int donutDamage;
    private ArrayList<DonutC> donutC;
    private boolean punching;
    private int punchDamage;
    private int punchRange;
    private boolean gliding;
    private ArrayList<BufferedImage[]> sprites;
    private final int[] numFrames = new int[]{2, 8, 1, 1, 1, 1, 5};
    private static final int IDLE = 0;
    private static final int WALKING = 1;
    private static final int JUMPING = 2;
    private static final int FALLING = 3;
    private static final int GLIDING = 4;
    private static final int DONUTING = 5;
    private static final int PUNCHING = 6;

    public Player(TileMap tm) {
        super(tm);
        this.width = 30;
        this.height = 30;
        this.cwidth = 20;
        this.cheight = 20;
        this.moveSpeed = 0.3;
        this.maxSpeed = 1.6;
        this.stopSpeed = 0.4;
        this.fallSpeed = 0.15;
        this.maxFallSpeed = 4.0;
        this.jumpStart = -4.8;
        this.stopJumpSpeed = 0.3;
        this.facingRight = true;
        this.maxHealth = 5;
        this.health = 5;
        this.maxDonut = 2500;
        this.donut = 2500;
        this.donutCost = 200;
        this.donutDamage = 5;
        this.donutC = new ArrayList();
        this.punchDamage = 10;
        this.punchRange = 40;
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Player/playersprites.gif"));
            this.sprites = new ArrayList();
            int i = 0;
            while (i < 7) {
                BufferedImage[] bi = new BufferedImage[this.numFrames[i]];
                int j = 0;
                while (j < this.numFrames[i]) {
                    bi[j] = i != 6 ? spritesheet.getSubimage(j * this.width, i * this.height, this.width, this.height) : spritesheet.getSubimage(j * 60, 180, 60, this.height);
                    ++j;
                }
                this.sprites.add(bi);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.currentAction = 0;
        this.animation.setFrames(this.sprites.get(0));
        this.animation.setDelay(400L);
    }

    public int getHealth() {
        return this.health;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public int getDonut() {
        return this.donut;
    }

    public int getMaxDonut() {
        return this.maxDonut;
    }

    public boolean getGliding() {
        return this.gliding;
    }

    public boolean getJumping() {
        return this.jumping;
    }

    public boolean getFalling() {
        return this.falling;
    }

    public void setDonuting() {
        this.donuting = true;
    }

    public void setPunching() {
        this.punching = true;
    }

    public void setGliding(boolean b) {
        this.gliding = b;
    }

    public int getX() {
        return (int)(this.x + this.xmap - (double)(this.width / 2));
    }

    public int getY() {
        return (int)(this.y + this.ymap - (double)(this.height / 2));
    }

    public void setHealth(int h) {
        this.health = h;
    }

    public void setDonut(int d) {
        this.donut = d;
    }

    public void checkAttack(ArrayList<Enemy> enemies) {
        int i = 0;
        while (i < enemies.size()) {
            Enemy e = enemies.get(i);
            if (this.punching) {
                if (this.facingRight) {
                    if ((double)e.getx() > this.x && (double)e.getx() < this.x + (double)this.punchRange && (double)e.gety() > this.y - (double)(this.height / 2) && (double)e.gety() < this.y + (double)(this.height / 2)) {
                        e.hit(this.punchDamage);
                    }
                } else if ((double)e.getx() < this.x && (double)e.getx() > this.x - (double)this.punchRange && (double)e.gety() > this.y - (double)(this.height / 2) && (double)e.gety() < this.y + (double)(this.height / 2)) {
                    e.hit(this.punchDamage);
                }
            }
            int j = 0;
            while (j < this.donutC.size()) {
                if (this.donutC.get(j).intersets(enemies.get(i))) {
                    e.hit(this.donutDamage);
                    this.donutC.get(j).setHit();
                    break;
                }
                ++j;
            }
            if (this.intersets(e)) {
                this.hit(e.getDamage());
            }
            ++i;
        }
    }

    public void hit(int damage) {
        if (this.flinching) {
            return;
        }
        this.health -= damage;
        if (this.health < 0) {
            this.health = 0;
        }
        if (this.health == 0) {
            this.dead = true;
        }
        this.flinching = true;
        this.flinchTimer = System.nanoTime();
    }

    private void getNextPosition() {
        if (this.left) {
            this.dx -= this.moveSpeed;
            if (this.dx < -this.maxSpeed) {
                this.dx = -this.maxSpeed;
            }
        } else if (this.right) {
            this.dx += this.moveSpeed;
            if (this.dx > this.maxSpeed) {
                this.dx = this.maxSpeed;
            }
        } else if (this.dx > 0.0) {
            this.dx -= this.stopSpeed;
            if (this.dx < 0.0) {
                this.dx = 0.0;
            }
        } else if (this.dx < 0.0) {
            this.dx += this.stopSpeed;
            if (this.dx > 0.0) {
                this.dx = 0.0;
            }
        }
        if (!(this.currentAction != 6 && this.currentAction != 5 || this.jumping || this.falling)) {
            this.dx = 0.0;
        }
        if (this.jumping && !this.falling) {
            this.dy = this.jumpStart;
            this.falling = true;
        }
        if (this.falling) {
            this.dy = this.dy > 0.0 && this.gliding ? (this.dy += this.fallSpeed * 0.1) : (this.dy += this.fallSpeed * 0.9);
            if (this.dy > 0.0) {
                this.jumping = false;
            }
            if (this.dy < 0.0 && !this.jumping) {
                this.dy += this.stopJumpSpeed;
            }
            if (this.dy > this.maxFallSpeed) {
                this.dy = this.maxFallSpeed;
            }
        }
    }

    public void update(GameStateManager gsm) {
        long elapsed;
        this.getNextPosition();
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.currentAction == 6 && this.animation.hasPlayedOnce()) {
            this.punching = false;
        }
        if (this.currentAction == 5 && this.animation.hasPlayedOnce()) {
            this.donuting = false;
        }
        ++this.donut;
        if (this.donut > this.maxDonut) {
            this.donut = this.maxDonut;
        }
        if (this.donuting && this.currentAction != 5 && this.donut > this.donutCost) {
            this.donut -= this.donutCost;
            DonutC dc = new DonutC(this.tileMap, this.facingRight);
            dc.setPosition(this.x, this.y);
            this.donutC.add(dc);
        }
        int i = 0;
        while (i < this.donutC.size()) {
            this.donutC.get(i).update();
            if (this.donutC.get(i).shouldRemove()) {
                this.donutC.remove(i);
                --i;
            }
            ++i;
        }
        if (this.flinching && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) > 2000L) {
            this.flinching = false;
        }
        if (this.punching) {
            if (this.currentAction != 6) {
                this.currentAction = 6;
                this.animation.setFrames(this.sprites.get(6));
                this.animation.setDelay(50L);
                this.width = 30;
            }
        } else if (this.donuting) {
            if (this.currentAction != 5) {
                this.currentAction = 5;
                this.animation.setFrames(this.sprites.get(5));
                this.animation.setDelay(60L);
                this.width = 30;
            }
        } else if (this.dy > 0.0) {
            if (this.gliding) {
                if (this.currentAction != 4) {
                    this.currentAction = 4;
                    this.animation.setFrames(this.sprites.get(4));
                    this.animation.setDelay(100L);
                    this.width = 30;
                }
            } else if (this.currentAction != 3) {
                this.currentAction = 3;
                this.animation.setFrames(this.sprites.get(3));
                this.animation.setDelay(100L);
                this.width = 30;
            }
        } else if (this.dy < 0.0) {
            if (this.currentAction != 2) {
                this.currentAction = 2;
                this.animation.setFrames(this.sprites.get(2));
                this.animation.setDelay(-1L);
                this.width = 30;
            }
        } else if (this.left || this.right) {
            if (this.currentAction != 1) {
                this.currentAction = 1;
                this.animation.setFrames(this.sprites.get(1));
                this.animation.setDelay(40L);
                this.width = 30;
            }
        } else if (this.currentAction != 0) {
            this.currentAction = 0;
            this.animation.setFrames(this.sprites.get(0));
            this.animation.setDelay(400L);
            this.width = 30;
        }
        this.animation.update();
        if (this.currentAction != 6 && this.currentAction != 5) {
            if (this.right) {
                this.facingRight = true;
            }
            if (this.left) {
                this.facingRight = false;
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        long elapsed;
        this.setMapPosition();
        if (this.flinching && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) / 100L % 2L == 0L) {
            return;
        }
        int i = 0;
        while (i < this.donutC.size()) {
            this.donutC.get(i).draw(g);
            ++i;
        }
        if (this.facingRight) {
            g.drawImage((Image)this.animation.getImage(), (int)(this.x + this.xmap - (double)(this.width / 2)), (int)(this.y + this.ymap - (double)(this.height / 2)), null);
        } else if (this.currentAction == 6) {
            g.drawImage(this.animation.getImage(), (int)(this.x + this.xmap - (double)(this.width / 2) + (double)this.width), (int)(this.y + this.ymap - (double)(this.height / 2)), -this.width * 2, this.height, null);
        } else {
            g.drawImage(this.animation.getImage(), (int)(this.x + this.xmap - (double)(this.width / 2) + (double)this.width), (int)(this.y + this.ymap - (double)(this.height / 2)), -this.width, this.height, null);
        }
    }
}

