/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import GameState.DeathSceneState;
import GameState.GameState;
import GameState.LoadingData;
import GameState.LoadingScreen;
import GameState.MenuState;
import GameState.SoundOptions;
import GameState.w1.Level1State;
import GameState.w1.Level2State;
import java.awt.Graphics2D;

public class GameStateManager {
    public GameState[] states;
    public int currentState = 5;
    private int[] empty = new int[]{1, 1, 64, 300, 5, 2500};
    public static final int NUMGAMESTATES = 7;
    public static final int MENUSTATE = 0;
    public static final int LEVEL1STATE = 1;
    public static final int LEVEL2STATE = 2;
    public static final int DEATHSCENE = 3;
    public static final int SOUNDOPTIONS = 4;
    public static final int LOADINGSCREEN = 5;
    public static final int LOADINGDATA = 6;

    public GameStateManager() {
        this.states = new GameState[7];
        this.states[5] = new LoadingScreen(this, 0, this.empty);
        if (this.currentState == 743932) {
            System.exit(0);
        }
    }

    private void loadState(int state, int newState, int[] data) {
        if (state == 0) {
            this.states[state] = new MenuState(this);
        }
        if (state == 1) {
            this.states[state] = new Level1State(this, data);
        }
        if (state == 2) {
            this.states[state] = new Level2State(this, data);
            this.currentState = state;
        }
        if (state == 6) {
            this.states[state] = new LoadingData(this, data);
        }
        if (state == 3) {
            this.states[state] = new DeathSceneState(this);
        }
        if (state == 4) {
            this.states[state] = new SoundOptions(this);
        }
        if (state == 5) {
            this.states[state] = new LoadingScreen(this, newState, data);
        }
    }

    public void unloadState(int state) {
        this.states[state] = null;
    }

    public void setState(int state, int newState, int[] data) {
        this.unloadState(this.currentState);
        this.currentState = state;
        this.loadState(this.currentState, newState, data);
    }

    public void update() {
        try {
            this.states[this.currentState].update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void draw(Graphics2D g) {
        try {
            this.states[this.currentState].draw(g);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(System.currentTimeMillis()) + "DRAW");
            e.printStackTrace();
        }
    }

    public void keyPressed(int k) {
        try {
            this.states[this.currentState].keyPressed(k);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void keyReleased(int k) {
        try {
            this.states[this.currentState].keyReleased(k);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

