/*
 * Decompiled with CFR 0.152.
 */
package GameState.w1;

import Audio.AudioPlayer;
import Entity.Enemies.Brocky;
import Entity.Enemies.Carrot2;
import Entity.Enemies.Slugger;
import Entity.Enemy;
import Entity.Explosion;
import Entity.HUD;
import Entity.Player;
import GameState.GameState;
import GameState.GameStateManager;
import TileMap.Background;
import TileMap.TileMap;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import main.menuOptions.settingsOptions.ChangeCommands;
import save.SaveManager;

public class Level2State
extends GameState {
    private TileMap tileMap;
    private Background bg;
    private Player player;
    private int[] empty = new int[]{1, 2, 64, 100, 5, 2500};
    private int[] saveData = new int[5];
    private ArrayList<Enemy> enemies;
    private ArrayList<Explosion> explosions;
    private HUD hud;
    private AudioPlayer bgMusic;
    private File musicPath;
    private int loadingString;
    private boolean load = false;

    public Level2State(GameStateManager gsm, int[] save) {
        super(gsm);
        this.saveData = save;
        this.loadingString = 0;
    }

    @Override
    public void init() {
        this.tileMap = new TileMap(32);
        this.tileMap.loadTiles("/Tilesets/cavetileset.png");
        this.tileMap.loadMap("/Maps/level2-1.map");
        this.tileMap.setPosition(0.0, 0.0);
        this.bg = new Background("/Backgrounds/cave.png");
        this.player = new Player(this.tileMap);
        this.creaNemici();
        this.explosions = new ArrayList();
        this.hud = new HUD(this.player);
    }

    private void creaNemici() {
        this.enemies = new ArrayList();
        Point[] sluggerPoints = new Point[]{new Point(270, 100), new Point(690, 170), new Point(750, 170), new Point(1550, 200), new Point(1900, 150), new Point(1680, 180), new Point(1780, 180), new Point(1900, 170)};
        Point[] brockPoints = new Point[]{new Point(590, 160), new Point(810, 130), new Point(1710, 90), new Point(1840, 60), new Point(1260, 90), new Point(2830, 130), new Point(3370, 130)};
        Point[] carrotPoints = new Point[]{new Point(590, 160), new Point(810, 130), new Point(1710, 90), new Point(1840, 60), new Point(1260, 90), new Point(2830, 130), new Point(3370, 130)};
        int i = 0;
        while (i < sluggerPoints.length) {
            Slugger s = new Slugger(this.tileMap);
            s.setPosition(sluggerPoints[i].x, sluggerPoints[i].y);
            this.enemies.add(s);
            ++i;
        }
        i = 0;
        while (i < brockPoints.length) {
            Brocky b = new Brocky(this.tileMap, this.player);
            b.setPosition(brockPoints[i].x, brockPoints[i].y);
            this.enemies.add(b);
            ++i;
        }
        i = 0;
        while (i < carrotPoints.length) {
            Carrot2 c = new Carrot2(this.tileMap);
            c.setPosition(carrotPoints[i].x, carrotPoints[i].y);
            this.enemies.add(c);
            ++i;
        }
    }

    @Override
    protected void update() {
        if (!this.load) {
            this.player.setPosition(this.saveData[2], this.saveData[3]);
            this.player.setHealth(this.saveData[4]);
            this.player.setDonut(this.saveData[5]);
            this.load = true;
        }
        ++this.loadingString;
        if (this.player.gety() > 270) {
            this.gsm.setState(3, 3, this.empty);
        }
        if (this.player.getHealth() < 1) {
            this.gsm.setState(3, 3, this.empty);
        }
        this.player.getx();
        this.player.update(this.gsm);
        this.tileMap.setPosition(256 - this.player.getx(), 128 - this.player.gety());
        this.player.checkAttack(this.enemies);
        int i = 0;
        while (i < this.enemies.size()) {
            Enemy e = this.enemies.get(i);
            e.update();
            if (e.isDead()) {
                this.enemies.remove(i);
                --i;
                this.explosions.add(new Explosion(e.getx(), e.gety()));
            }
            ++i;
        }
        i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).update();
            if (this.explosions.get(i).shouldRemove()) {
                this.explosions.remove(i);
                --i;
            }
            ++i;
        }
    }

    @Override
    protected void draw(Graphics2D g) {
        this.bg.draw(g);
        this.tileMap.draw(g);
        this.player.draw(g);
        int i = 0;
        while (i < this.enemies.size()) {
            this.enemies.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).setMapPosition(this.tileMap.getx(), this.tileMap.gety());
            this.explosions.get(i).draw(g);
            ++i;
        }
        this.hud.draw(g);
        if (this.loadingString < 100) {
            g.setFont(new Font("Consolas", 0, 12));
            g.setColor(Color.WHITE);
            g.drawString("Il tuo PC potrebbe impiegare un p\u00f2 di tempo a caricare il livello", 2, 245);
        }
    }

    @Override
    protected void keyPressed(int k) {
        if (k == ChangeCommands.commands[1]) {
            this.player.setLeft(true);
        }
        if (k == ChangeCommands.commands[0]) {
            this.player.setRight(true);
        }
        if (k == ChangeCommands.commands[3]) {
            this.player.setUp(true);
        }
        if (k == ChangeCommands.commands[4]) {
            this.player.setDown(true);
        }
        if (k == ChangeCommands.commands[2]) {
            this.player.setJumping(true);
        }
        if (k == ChangeCommands.commands[5]) {
            this.player.setGliding(true);
        }
        if (k == ChangeCommands.commands[6]) {
            this.player.setPunching();
        }
        if (k == ChangeCommands.commands[7]) {
            this.player.setDonuting();
        }
        if (k == 27) {
            SaveManager.save(1, 2, this.player.getx(), this.player.gety(), this.player.getHealth(), this.player.getDonut());
            this.gsm.setState(5, 0, this.empty);
        }
        if (k == ChangeCommands.commands[8]) {
            SaveManager.save(1, 2, this.player.getx(), this.player.gety(), this.player.getHealth(), this.player.getDonut());
        }
    }

    @Override
    protected void keyReleased(int k) {
        if (k == ChangeCommands.commands[1]) {
            this.player.setLeft(false);
        }
        if (k == ChangeCommands.commands[0]) {
            this.player.setRight(false);
        }
        if (k == ChangeCommands.commands[3]) {
            this.player.setUp(false);
        }
        if (k == ChangeCommands.commands[4]) {
            this.player.setDown(false);
        }
        if (k == ChangeCommands.commands[2]) {
            this.player.setJumping(false);
        }
        if (k == ChangeCommands.commands[5]) {
            this.player.setGliding(false);
        }
    }
}

