/*
 * Decompiled with CFR 0.152.
 */
package GameState.w1;

import Audio.AudioPlayer;
import Entity.Coin;
import Entity.Enemies.Brocky;
import Entity.Enemies.Carrot2;
import Entity.Enemies.Slugger;
import Entity.Enemy;
import Entity.Explosion;
import Entity.HUD;
import Entity.Heart;
import Entity.Player;
import GameState.GameState;
import GameState.GameStateManager;
import TileMap.Background;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import main.menuOptions.Settings;
import main.menuOptions.settingsOptions.ChangeCommands;
import save.SaveManager;

public class Level1State
extends GameState {
    private TileMap tileMap;
    private Background bg;
    private Player player;
    private Random random = new Random();
    private String mapPath;
    private int numColumnItems;
    private int numColumn;
    private ArrayList<Enemy> enemies;
    private ArrayList<Explosion> explosions;
    private ArrayList<Heart> heart;
    private ArrayList<Coin> coin;
    private Heart oheart;
    private int rand = 0;
    public boolean alreadyDead;
    private int[] empty = new int[]{1, 2, 64, 100, 5, 2500};
    private int[] saveData = new int[5];
    private HUD hud;
    private AudioPlayer bgMusic;
    private File musicPath;
    private boolean load = false;
    private HashMap<String, AudioPlayer> sfx;
    String saveFilePath = System.getProperty("user.dir");
    File oldFile = new File(this.saveFilePath);
    File saveFile = new File(this.oldFile + "/data/saves/save.pierlu");

    public Level1State(GameStateManager gsm, int[] save) {
        super(gsm);
        this.saveData = save;
        this.sfx = new HashMap();
        this.sfx.put("coin", new AudioPlayer("/Sounds/SFX/coin.wav"));
        this.sfx.put("death", new AudioPlayer("/Sounds/SFX/death.wav"));
        this.sfx.put("tube", new AudioPlayer("/Sounds/SFX/tube.wav"));
        this.sfx.put("finish", new AudioPlayer("/Sounds/SFX/select_confirm.wav"));
    }

    @Override
    public void init() {
        this.mapPath = "/Maps/level1-1.map";
        this.tileMap = new TileMap(32);
        this.tileMap.loadTiles("/Tilesets/grasstileset.png");
        this.tileMap.loadMap(this.mapPath);
        this.tileMap.setPosition(0.0, 0.0);
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/cave.png") : new Background("/Backgrounds/error.jpg"));
        this.player = new Player(this.tileMap);
        this.alreadyDead = false;
        this.creaNemici();
        this.explosions = new ArrayList();
        this.heart = new ArrayList();
        this.coin = new ArrayList();
        this.hud = new HUD(this.player);
        InputStream in = this.getClass().getResourceAsStream(this.mapPath);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            br.readLine();
            this.numColumn = Integer.parseInt(br.readLine());
            int col = 0;
            while (col < this.numColumn) {
                br.readLine();
                ++col;
            }
            this.numColumnItems = Integer.parseInt(br.readLine());
            System.out.println(this.numColumnItems);
            int i = 0;
            while (i < this.numColumnItems) {
                String line = br.readLine();
                String[] tokens = line.split("-");
                int tileX = Integer.parseInt(tokens[0]);
                int tileY = Integer.parseInt(tokens[1]);
                int coinX = tileX * 32 + 16;
                int coinY = tileY * 32 + 16;
                this.coin.add(new Coin(this.tileMap, coinX, coinY, this.player));
                ++i;
            }
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void creaNemici() {
        this.enemies = new ArrayList();
        Point[] sluggerPoints = new Point[]{new Point(200, 100), new Point(1620, 400), new Point(1900, 200), new Point(1600, 100), new Point(1900, 400), new Point(2200, 50), new Point(2700, 300), new Point(1559, 300)};
        Point[] brockPoints = new Point[]{new Point(1130, 400), new Point(1675, 280), new Point(2160, 340), new Point(3020, 320)};
        Point[] carrotPoints = new Point[]{new Point(1130, 400), new Point(1675, 280), new Point(2160, 340), new Point(3020, 320)};
        int i = 0;
        while (i < sluggerPoints.length) {
            Slugger s = new Slugger(this.tileMap);
            s.setPosition(sluggerPoints[i].x, sluggerPoints[i].y);
            this.enemies.add(s);
            ++i;
        }
        i = 0;
        while (i < brockPoints.length) {
            Brocky b = new Brocky(this.tileMap, this.player);
            b.setPosition(brockPoints[i].x, brockPoints[i].y);
            this.enemies.add(b);
            ++i;
        }
        i = 0;
        while (i < carrotPoints.length) {
            Carrot2 c = new Carrot2(this.tileMap);
            c.setPosition(carrotPoints[i].x, carrotPoints[i].y);
            this.enemies.add(c);
            ++i;
        }
    }

    @Override
    protected void update() {
        if (!this.load) {
            this.player.setPosition(this.saveData[2], this.saveData[3]);
            this.player.setHealth(this.saveData[4]);
            this.player.setDonut(this.saveData[5]);
            this.load = true;
        }
        if (this.player.gety() > 465) {
            this.sfx.get("death").play();
            this.gsm.setState(3, 3, this.empty);
        }
        if (this.player.getHealth() < 1) {
            this.sfx.get("death").play();
            this.gsm.setState(3, 3, this.empty);
        }
        if (this.player.getx() > 3680) {
            this.sfx.get("finish").play();
            this.gsm.setState(5, 2, this.empty);
        }
        this.player.update(this.gsm);
        this.tileMap.setPosition(256 - this.player.getx(), 128 - this.player.gety());
        this.player.checkAttack(this.enemies);
        int i = 0;
        while (i < this.enemies.size()) {
            Enemy e = this.enemies.get(i);
            e.update();
            if (e.isDead()) {
                this.enemies.remove(i);
                --i;
                this.explosions.add(new Explosion(e.getx(), e.gety()));
                this.rand = this.random.nextInt(100);
                if (this.rand > 70) {
                    this.heart.add(new Heart(this.tileMap, e.getx(), e.gety(), this.player));
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).update();
            if (this.explosions.get(i).shouldRemove()) {
                this.explosions.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.heart.size()) {
            this.heart.get(i).update();
            if (this.heart.get(i).gety() > 465 && this.heart.get((int)i).animation.hasPlayedOnce()) {
                System.out.println("remove " + this.heart.get(i).getx());
                this.heart.get((int)i).remove = true;
            }
            if (this.heart.get(i).shouldRemove()) {
                this.heart.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.coin.size()) {
            this.coin.get(i).update();
            if (this.coin.get(i).shouldRemove()) {
                this.coin.remove(i);
                --i;
            }
            ++i;
        }
    }

    @Override
    protected void draw(Graphics2D g) {
        this.bg.draw(g);
        this.tileMap.draw(g);
        this.player.draw(g);
        int i = 0;
        while (i < this.enemies.size()) {
            this.enemies.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).setMapPosition(this.tileMap.getx(), this.tileMap.gety());
            this.explosions.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.heart.size()) {
            this.heart.get(i).draw(g);
            ++i;
        }
        i = 0;
        while (i < this.coin.size()) {
            this.coin.get(i).draw(g);
            ++i;
        }
        this.hud.draw(g);
    }

    @Override
    protected void keyPressed(int k) {
        if (k == ChangeCommands.commands[1]) {
            this.player.setLeft(true);
        }
        if (k == ChangeCommands.commands[0]) {
            this.player.setRight(true);
        }
        if (k == ChangeCommands.commands[3]) {
            this.player.setUp(true);
        }
        if (k == ChangeCommands.commands[4]) {
            this.player.setDown(true);
            this.checkCoke();
        }
        if (k == ChangeCommands.commands[2]) {
            this.player.setJumping(true);
        }
        if (k == ChangeCommands.commands[5]) {
            this.player.setGliding(true);
        }
        if (k == ChangeCommands.commands[6]) {
            this.player.setPunching();
        }
        if (k == ChangeCommands.commands[7]) {
            this.player.setDonuting();
        }
        if (k == 27) {
            SaveManager.save(1, 1, this.player.getx(), this.player.gety(), this.player.getHealth(), this.player.getDonut());
            this.gsm.setState(5, 0, this.empty);
        }
        if (k == ChangeCommands.commands[8]) {
            SaveManager.save(1, 1, this.player.getx(), this.player.gety(), this.player.getHealth(), this.player.getDonut());
        }
    }

    @Override
    protected void keyReleased(int k) {
        if (k == ChangeCommands.commands[1]) {
            this.player.setLeft(false);
        }
        if (k == ChangeCommands.commands[0]) {
            this.player.setRight(false);
        }
        if (k == ChangeCommands.commands[3]) {
            this.player.setUp(false);
        }
        if (k == ChangeCommands.commands[4]) {
            this.player.setDown(false);
        }
        if (k == ChangeCommands.commands[2]) {
            this.player.setJumping(false);
        }
        if (k == ChangeCommands.commands[5]) {
            this.player.setGliding(false);
        }
    }

    public void checkCoke() {
        if (this.player.getx() > 2420 && this.player.getx() < 2470 && this.player.gety() > 410 && this.player.gety() < 460) {
            this.sfx.get("tube").play();
            this.player.setPosition(1550.0, 60.0);
        }
        if (this.player.getx() > 2170 && this.player.getx() < 2210 && this.player.gety() > 60 && this.player.gety() < 100) {
            this.sfx.get("tube").play();
            this.player.setPosition(2860.0, 220.0);
        }
    }
}

