/*
 * Decompiled with CFR 0.152.
 */
package TileMap;

import TileMap.Tile;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;

public class TileMap {
    private double x;
    private double y;
    private int xmin;
    private int ymin;
    private int xmax;
    private int ymax;
    private double tween;
    private int[][] map;
    private int tileSize;
    private int numRow;
    private int numColumn;
    private int width;
    private int height;
    private BufferedImage tileSet;
    private int numTilesAcross;
    private Tile[][] tiles;
    private int rowOffset;
    private int columnOffset;
    private int numRowDraw;
    private int numColumnDraw;
    private int numColumnItems;

    public TileMap(int tileSize) {
        this.tileSize = tileSize;
        this.numRowDraw = 256 / tileSize + 2;
        this.numColumnDraw = 512 / tileSize + 2;
        this.tween = 0.07;
    }

    public void loadTiles(String s) {
        try {
            this.tileSet = ImageIO.read(this.getClass().getResourceAsStream(s));
            this.numTilesAcross = this.tileSet.getWidth() / this.tileSize;
            this.tiles = new Tile[3][this.numTilesAcross];
            int col = 0;
            while (col < this.numTilesAcross) {
                BufferedImage subImage = this.tileSet.getSubimage(col * this.tileSize, 0, this.tileSize, this.tileSize);
                this.tiles[0][col] = new Tile(subImage, 0);
                subImage = this.tileSet.getSubimage(col * this.tileSize, this.tileSize, this.tileSize, this.tileSize);
                this.tiles[1][col] = new Tile(subImage, 1);
                ++col;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadMap(String s) {
        try {
            InputStream in = this.getClass().getResourceAsStream(s);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            this.numColumn = Integer.parseInt(br.readLine());
            this.numRow = Integer.parseInt(br.readLine());
            this.map = new int[this.numRow][this.numColumn];
            this.width = this.numColumn * this.tileSize;
            this.height = this.numRow * this.tileSize;
            this.xmin = 512 - this.width;
            this.xmax = 0;
            this.ymin = 256 - this.height;
            this.ymax = 0;
            String delims = "\\s+";
            int row = 0;
            while (row < this.numRow) {
                String line = br.readLine();
                String[] tokens = line.split(delims);
                int col = 0;
                while (col < this.numColumn) {
                    this.map[row][col] = Integer.parseInt(tokens[col]);
                    ++col;
                }
                ++row;
            }
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getx() {
        return (int)this.x;
    }

    public int gety() {
        return (int)this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getType(int row, int col) {
        int rc = this.map[row][col];
        int r = rc / this.numTilesAcross;
        int c = rc % this.numTilesAcross;
        return this.tiles[r][c].getType();
    }

    public void setPosition(double x, double y) {
        this.x += (x - this.x) * this.tween;
        this.y += (y - this.y) * this.tween;
        this.fixBounds();
        this.columnOffset = (int)(-this.x) / this.tileSize;
        this.rowOffset = (int)(-this.y) / this.tileSize;
    }

    public void fixBounds() {
        if (this.x < (double)this.xmin) {
            this.x = this.xmin;
        }
        if (this.y < (double)this.ymin) {
            this.y = this.ymin;
        }
        if (this.x > (double)this.xmax) {
            this.x = this.xmax;
        }
        if (this.y > (double)this.ymax) {
            this.y = this.ymax;
        }
    }

    public void draw(Graphics2D g) {
        int row = this.rowOffset;
        while (row < this.rowOffset + this.numRowDraw) {
            if (row >= this.numRow) break;
            int col = this.columnOffset;
            while (col < this.columnOffset + this.numColumnDraw) {
                if (col >= this.numColumn) break;
                if (this.map[row][col] != 0) {
                    int rc = this.map[row][col];
                    int r = rc / this.numTilesAcross;
                    int c = rc % this.numTilesAcross;
                    g.drawImage((Image)this.tiles[r][c].getImage(), (int)this.x + col * this.tileSize, (int)this.y + row * this.tileSize, null);
                }
                ++col;
            }
            ++row;
        }
    }
}

