/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Audio.AudioPlayer;
import Entity.Animation;
import Entity.MapObject;
import Entity.Player;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class Heart
extends MapObject {
    private BufferedImage[] sprites;
    private BufferedImage[] hitSprites;
    public boolean remove;
    private Player player;
    private HashMap<String, AudioPlayer> sfx;
    static File soundsFiles = new File(System.getProperty("user.dir"));
    static String resFilePath = String.valueOf(soundsFiles.getParent()) + "\\res\\Audio\\SFX\\";

    public Heart(TileMap tm, int nx, int ny, Player p) {
        super(tm);
        this.fallSpeed = 0.5;
        this.maxFallSpeed = 10.0;
        this.x = nx;
        this.y = ny;
        this.width = 17;
        this.height = 17;
        this.cwidth = 20;
        this.cheight = 20;
        this.player = p;
        try {
            BufferedImage spriteS = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/items/heart.png"));
            this.sprites = new BufferedImage[3];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spriteS.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
            this.hitSprites = new BufferedImage[3];
            i = 0;
            while (i < this.hitSprites.length) {
                this.hitSprites[i] = spriteS.getSubimage(i * this.width, this.height, this.width, this.height);
                ++i;
            }
            this.animation = new Animation();
            this.animation.setFrames(this.sprites);
            this.animation.setDelay(250L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sfx = new HashMap();
        this.sfx.put("heart", new AudioPlayer(new File(String.valueOf(resFilePath) + "heart.wav")));
    }

    public void getNextPosition() {
        if (this.falling) {
            this.dy = this.fallSpeed;
        }
    }

    public void update() {
        if (this.gety() > 465) {
            if (this.animation.hasPlayedOnce()) {
                this.remove = true;
            }
            this.remove = true;
        } else {
            this.getNextPosition();
            this.checkTileMapCollision();
            this.setPosition(this.xtemp, this.ytemp);
            this.animation.update();
        }
        if ((double)this.player.getx() > this.xtemp - (double)this.cwidth && (double)this.player.getx() < this.xtemp + (double)this.cwidth && (double)this.player.gety() > this.ytemp - (double)this.cheight && (double)this.player.gety() < this.ytemp + (double)this.cheight) {
            this.sfx.get("heart").play();
            this.player.setHealth(this.player.getHealth() + 1);
            if (this.player.getHealth() > 5) {
                this.player.setHealth(5);
            }
            this.remove = true;
        }
    }

    public boolean shouldRemove() {
        return this.remove;
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        super.draw(g);
    }
}

