/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Audio.AudioPlayer;
import GameState.GameState;
import GameState.GameStateManager;
import TileMap.Background;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import main.menuOptions.Settings;

public class SoundOptions
extends GameState {
    private Background bg;
    private AudioPlayer tryMusic;
    public int currentSelection;
    private int[] empty;
    public static boolean music;
    public boolean sfx;
    public String[] audioOptionsChoice;
    public String[] audioOptions;

    public SoundOptions(GameStateManager gsm) {
        super(gsm);
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 64;
        nArray[3] = 300;
        nArray[4] = 1;
        this.empty = nArray;
        this.audioOptionsChoice = new String[]{"On", "On"};
        this.audioOptions = new String[]{"Musica:      " + this.audioOptionsChoice[0], "Effetti:     " + this.audioOptionsChoice[1]};
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/cave.png") : new Background("/Backgrounds/error.jpg"));
        File musicFile = new File(System.getProperty("user.dir"));
        File musicPath = new File(musicFile.getParentFile() + "\\res\\Audio\\Music\\cave.mp3");
        System.out.println(musicPath);
        this.currentSelection = 0;
    }

    @Override
    public void init() {
        this.currentSelection = 0;
    }

    @Override
    protected void update() {
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/cave.png") : new Background("/Backgrounds/error.jpg"));
        this.bg.update();
        String tempChoice = "ERROR";
        tempChoice = music ? "On" : "Off";
        this.audioOptions[0] = "Musica:      " + tempChoice;
        tempChoice = this.sfx ? "On" : "Off";
        this.audioOptions[1] = "Effetti:     " + tempChoice;
    }

    @Override
    protected void draw(Graphics2D g) {
        this.bg.draw(g);
        g.setColor(new Color(100, 0, 100));
        g.drawString("Impostazioni audio", 5, 25);
        int i = 0;
        while (i < this.audioOptions.length) {
            if (i == this.currentSelection) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawString(this.audioOptions[i], 15, 60 + i * 30);
            ++i;
        }
        g.drawString("Premi il tasto T per l'anteprima", 50, 200);
    }

    @Override
    protected void keyPressed(int k) {
        if (k == 38) {
            --this.currentSelection;
            if (this.currentSelection < 0) {
                this.currentSelection = this.audioOptions.length - 1;
            }
        }
        if (k == 40) {
            ++this.currentSelection;
            if (this.currentSelection >= this.audioOptions.length) {
                this.currentSelection = 0;
            }
        }
        if (k == 10) {
            if (this.currentSelection == 0) {
                music = !music;
            } else if (this.currentSelection == 1) {
                this.sfx = !this.sfx;
            }
        }
        if (k == 84) {
            try {
                this.tryMusic.play();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (k == 27) {
            try {
                this.tryMusic.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.gsm.setState(0, 0, this.empty);
        }
    }

    @Override
    protected void keyReleased(int k) {
    }
}

