/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.Enemy;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class LavaDrop
extends Enemy {
    private ArrayList<BufferedImage[]> sprites;
    private final int[] numFrames = new int[]{6, 9, 5, 8};
    private static final int IDLE = 0;
    private static final int JUMPING = 1;
    private static final int ATTACKING = 2;
    private static final int DYING = 3;

    public LavaDrop(TileMap tm) {
        super(tm);
        this.fallSpeed = 0.05;
        this.maxFallSpeed = 10.0;
        this.width = 32;
        this.height = 32;
        this.cwidth = 10;
        this.cheight = 10;
        this.maxHealth = 1;
        this.health = 1;
        this.damage = 1;
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/iceflake.gif"));
            this.sprites = new ArrayList();
            int i = 0;
            while (i < 4) {
                BufferedImage[] bi = new BufferedImage[this.numFrames[i]];
                int j = 0;
                while (j < this.numFrames[i]) {
                    bi[j] = spritesheet.getSubimage(j * this.width, i * this.height, this.width, this.height);
                    ++j;
                }
                this.sprites.add(bi);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.currentAction = 0;
        this.animation.setFrames(this.sprites.get(0));
        this.animation.setDelay(200L);
    }

    private void getNextPosition() {
        if (this.falling) {
            this.dy += this.fallSpeed;
        }
    }

    @Override
    public void update() {
        this.getNextPosition();
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp - 4.0);
        this.animation.update();
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        super.draw(g);
    }
}

