/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.Animation;
import GameState.GameState;
import GameState.GameStateManager;
import TileMap.Background;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import main.menuOptions.Settings;

public class DeathSceneState
extends GameState {
    private Background bg;
    private Font font;
    private Color color;
    private int[] empty;
    private BufferedImage[] sprites;
    private Animation animation;
    private int transition;

    public DeathSceneState(GameStateManager gsm) {
        super(gsm);
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 64;
        nArray[3] = 300;
        nArray[4] = 1;
        this.empty = nArray;
        this.transition = 0;
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/planet.png") : new Background("/Backgrounds/error.jpg"));
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Backgrounds/black_transition.png"));
            this.sprites = new BufferedImage[3];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spritesheet.getSubimage(i * 512, 0, 512, 256);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.font = new Font("Calibri", 0, 24);
        this.color = new Color(255, 0, 0);
        this.animation = new Animation();
        this.animation.setFrames(this.sprites);
        this.animation.setDelay(50L);
    }

    @Override
    public void init() {
    }

    @Override
    protected void update() {
        this.bg.update();
        if (this.transition < 30) {
            this.animation.update();
        }
        ++this.transition;
    }

    @Override
    protected void draw(Graphics2D g) {
        this.bg.draw(g);
        g.drawImage((Image)this.animation.getImage(), 0, 0, null);
        g.setFont(this.font);
        g.setColor(this.color);
        g.drawString("Sei morto!", 188, 80);
        g.drawString("Premi invio per continuare...", 110, 100);
    }

    @Override
    protected void keyPressed(int k) {
        if (k == 10) {
            this.gsm.setState(0, 0, this.empty);
        }
    }

    @Override
    protected void keyReleased(int k) {
    }
}

