/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Audio.AudioPlayer;
import GameState.GameState;
import GameState.GameStateManager;
import TileMap.Background;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.File;
import java.util.HashMap;
import main.Game;
import main.menuOptions.Help;
import main.menuOptions.Settings;
import save.SaveManager;

public class MenuState
extends GameState {
    private Font SPB;
    private Background bg;
    private SaveManager sm;
    private int currentSelection = 0;
    private String[] options = new String[]{"Nuova partita", "Continua", "Comandi", "Impostazioni", "Audio", "Esci"};
    private int[] empty = new int[]{1, 1, 64, 300, 5, 2500};
    private Color titleColor;
    private Font titleFont;
    private Font font;
    private HashMap<String, AudioPlayer> sfx;
    static File soundsFiles = new File(System.getProperty("user.dir"));
    static String resFilePath = "Sounds/SFX/";

    public MenuState(GameStateManager gsm) {
        super(gsm);
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/cave.png") : new Background("/Backgrounds/error.jpg"));
        this.titleColor = new Color(100, 0, 100);
        this.titleFont = new Font("Calibri", 0, 48);
        this.font = new Font("Calibri", 1, 24);
        this.sfx = new HashMap();
        this.sfx.put("select", new AudioPlayer(String.valueOf(resFilePath) + "select.wav"));
        this.sfx.put("confirm", new AudioPlayer(String.valueOf(resFilePath) + "select_confirm.wav"));
        this.sfx.put("exit", new AudioPlayer(String.valueOf(resFilePath) + "exit.wav"));
    }

    @Override
    public void init() {
    }

    @Override
    protected void update() {
        this.bg = Settings.backgroundSelection == 0 ? new Background("/Backgrounds/sea.png") : (Settings.backgroundSelection == 1 ? new Background("/Backgrounds/cave.png") : new Background("/Backgrounds/error.jpg"));
        this.bg.update();
    }

    @Override
    protected void draw(Graphics2D g) {
        this.bg.draw(g);
        g.setColor(this.titleColor);
        g.setFont(this.titleFont);
        g.drawString("Super Pierlu Bros", 85, 64);
        g.setFont(this.font);
        int i = 0;
        while (i < this.options.length) {
            if (i == this.currentSelection) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(Color.RED);
            }
            g.drawString(this.options[i], 87, 98 + i * 24);
            ++i;
        }
    }

    @Override
    protected void keyPressed(int k) {
        if (k == 40) {
            this.sfx.get("select").play();
            ++this.currentSelection;
            if (this.currentSelection >= this.options.length) {
                this.currentSelection = 0;
            }
        } else if (k == 38) {
            this.sfx.get("select").play();
            --this.currentSelection;
            if (this.currentSelection < 0) {
                this.currentSelection = this.options.length - 1;
            }
        }
        if (k == 10) {
            if (this.currentSelection == 0) {
                this.sfx.get("confirm").play();
                SaveManager.startNewGame();
                this.gsm.setState(5, 1, this.empty);
            } else if (this.currentSelection == 1) {
                this.sfx.get("confirm").play();
                this.gsm.setState(5, 6, SaveManager.loadSave());
            } else if (this.currentSelection == 2) {
                this.sfx.get("confirm").play();
                Help.main(null);
                Game.window.setEnabled(false);
            } else if (this.currentSelection == 3) {
                this.sfx.get("confirm").play();
                Settings.main(null);
                Game.window.setEnabled(false);
            } else if (this.currentSelection == 4) {
                this.sfx.get("confirm").play();
                this.gsm.setState(5, 4, this.empty);
            } else if (this.currentSelection == 5) {
                this.sfx.get("exit").play();
                System.exit(0);
            }
        }
    }

    @Override
    protected void keyReleased(int k) {
    }
}

