/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.Enemy;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Carrot2
extends Enemy {
    private double dx;
    private double dy;
    private int direction = 0;
    private boolean hit;
    private boolean remove;
    private BufferedImage[] sprites;
    private BufferedImage[] hitSprites;
    private double initX;
    private boolean left = false;
    private int initxcounter = 0;

    public Carrot2(TileMap tm) {
        super(tm);
        this.facingRight = this.right;
        this.moveSpeed = 0.5;
        this.maxSpeed = 1.0;
        this.fallSpeed = 0.5;
        this.maxFallSpeed = 10.0;
        this.dx = 0.5;
        this.width = 16;
        this.height = 16;
        this.cwidth = 20;
        this.cheight = 20;
        this.maxHealth = 1;
        this.health = 1;
        this.damage = 1;
        try {
            BufferedImage spriteS = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/carrot.gif"));
            this.sprites = new BufferedImage[3];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spriteS.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
            this.hitSprites = new BufferedImage[3];
            i = 0;
            while (i < this.hitSprites.length) {
                this.hitSprites[i] = spriteS.getSubimage(i * this.width, this.height, this.width, this.height);
                ++i;
            }
            this.animation = new Animation();
            this.animation.setFrames(this.sprites);
            this.animation.setDelay(100L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void getNextPosition() {
        this.dx = this.left ? this.moveSpeed - this.moveSpeed - this.moveSpeed : this.moveSpeed;
    }

    @Override
    public void update() {
        if (this.initxcounter < 2) {
            this.initX = this.x;
            ++this.initxcounter;
        }
        this.getNextPosition();
        this.checkCollision();
        this.setPosition(this.xtemp, this.ytemp);
        this.animation.update();
        if (this.hit && this.animation.hasPlayedOnce()) {
            this.remove = true;
        }
    }

    public boolean shouldRemove() {
        return this.remove;
    }

    public void setHit() {
        if (this.hit) {
            return;
        }
        this.hit = true;
        this.animation.setFrames(this.hitSprites);
        this.animation.setDelay(45L);
        this.dx = 0.0;
    }

    public void checkCollision() {
        this.currColumn = (int)this.x / this.tileSize;
        this.currRow = (int)this.y / this.tileSize;
        this.xdest = this.x + this.dx;
        this.ydest = this.y + this.dy;
        this.xtemp = this.x;
        this.ytemp = this.y;
        if (this.x > this.initX + 110.0) {
            this.left = true;
            this.xtemp -= this.dx;
        } else if (this.x < this.initX - 110.0) {
            this.left = false;
            this.xtemp += this.dx;
        } else {
            this.calculateCorners(this.x, this.ydest);
            if (this.dy < 0.0) {
                if (this.topLeft || this.topRight) {
                    this.dy = 0.0;
                    this.ytemp = this.currRow * this.tileSize + this.cheight / 2;
                } else {
                    this.ytemp += this.dy;
                }
            }
            if (this.dy > 0.0) {
                if (this.bottomLeft || this.bottomRight) {
                    this.dy = 0.0;
                    this.falling = false;
                    this.ytemp = (this.currRow + 1) * this.tileSize - this.cheight / 2;
                } else {
                    this.ytemp += this.dy;
                }
            }
            this.calculateCorners(this.xdest, this.y);
            if (this.dx < 0.0) {
                if (this.topLeft || this.bottomLeft) {
                    this.dx = 0.0;
                    this.xtemp = this.currColumn * this.tileSize + this.cwidth / 2;
                } else {
                    this.xtemp += this.dx;
                }
            }
            if (this.dx > 0.0) {
                if (this.topRight || this.bottomRight) {
                    this.left = true;
                    this.xtemp -= this.dx;
                } else {
                    this.xtemp += this.dx;
                }
            }
            if (!this.falling) {
                this.calculateCorners(this.x, this.ydest + 1.0);
                if (!this.bottomLeft && !this.bottomRight) {
                    this.falling = true;
                }
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        super.draw(g);
    }
}

