/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import GameState.DeathSceneState;
import GameState.GameState;
import GameState.LoadingData;
import GameState.LoadingScreen;
import GameState.MenuState;
import GameState.SoundOptions;
import GameState.w0.Level1State;
import GameState.w0.Level2State;
import GameState.w0.Level3State;
import GameState.w0.Level4State;
import GameState.w0.Level5State;
import GameState.w0.Level6State;
import GameState.w0.Level7State;
import GameState.w0.Level8State;
import java.awt.Graphics2D;

public class GameStateManager {
    public GameState[] states;
    public int currentState = 5;
    private int[] empty = new int[]{1, 1, 64, 300, 5, 2500};
    private Level1State l1;
    private Level2State l2;
    private Level3State l3;
    private Level4State l4;
    private Level5State l5;
    private Level6State l6;
    private Level7State l7;
    private Level8State l8;
    public static final int NUMGAMESTATES = 14;
    public static final int MENUSTATE = 0;
    public static final int LEVEL1STATE = 1;
    public static final int LEVEL2STATE = 2;
    public static final int DEATHSCENE = 3;
    public static final int SOUNDOPTIONS = 4;
    public static final int LOADINGSCREEN = 5;
    public static final int LOADINGDATA = 6;
    public static final int LEVEL1_3STATE = 7;
    public static final int LEVEL3STATE = 8;
    public static final int LEVEL4STATE = 9;
    public static final int LEVEL5STATE = 10;
    public static final int LEVEL6STATE = 11;
    public static final int LEVEL7STATE = 12;
    public static final int LEVEL8STATE = 13;

    public GameStateManager() {
        this.states = new GameState[14];
        this.states[5] = new LoadingScreen(this, 0, this.empty);
        if (this.currentState == 743932) {
            System.exit(0);
        }
    }

    private void loadState(int state, int newState, int[] data) {
        if (state == 0) {
            this.states[state] = new MenuState(this);
        }
        if (state == 1) {
            this.l1 = new Level1State(this, data);
            this.states[state] = this.l1;
            this.currentState = state;
        }
        if (state == 2) {
            this.l2 = new Level2State(this, data);
            this.states[state] = this.l2;
            this.currentState = state;
        }
        if (state == 8) {
            this.l3 = new Level3State(this, data);
            this.states[state] = this.l3;
            this.currentState = state;
        }
        if (state == 9) {
            this.l4 = new Level4State(this, data);
            this.states[state] = this.l4;
            this.currentState = state;
        }
        if (state == 10) {
            this.l5 = new Level5State(this, data);
            this.states[state] = this.l5;
            this.currentState = state;
        }
        if (state == 11) {
            this.states[state] = new Level6State(this, data);
            this.currentState = state;
        }
        if (state == 12) {
            this.states[state] = new Level7State(this, data);
            this.currentState = state;
        }
        if (state == 13) {
            this.states[state] = new Level8State(this, data);
            this.currentState = state;
        }
        if (state == 6) {
            this.states[state] = new LoadingData(this, data);
        }
        if (state == 3) {
            this.states[state] = new DeathSceneState(this);
        }
        if (state == 4) {
            this.states[state] = new SoundOptions(this);
        }
        if (state == 5) {
            this.states[state] = new LoadingScreen(this, newState, data);
        }
    }

    public void unloadState(int state) {
        if (state == 1) {
            this.l1.finalize();
            this.l1 = null;
        }
        if (state == 2) {
            this.l2.finalize();
            this.l2 = null;
        }
        if (state == 8) {
            this.l3 = null;
        }
        if (state == 9) {
            this.l4 = null;
        }
        if (state == 10) {
            this.l5 = null;
        }
        this.states[state] = null;
    }

    public void setState(int state, int newState, int[] data) {
        this.unloadState(this.currentState);
        this.currentState = state;
        this.loadState(this.currentState, newState, data);
    }

    public void update() {
        try {
            this.states[this.currentState].update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void draw(Graphics2D g) {
        try {
            this.states[this.currentState].draw(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(int k) {
        try {
            this.states[this.currentState].keyPressed(k);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void keyReleased(int k) {
        try {
            this.states[this.currentState].keyReleased(k);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

