/*
 * Decompiled with CFR 0.152.
 */
package main;

import GameState.GameStateManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.JPanel;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener {
    public static final int WIDTH = 512;
    public static final int HEIGHT = 256;
    public static int SCALE = 2;
    String settingsFilePath = System.getProperty("user.dir");
    File oldFile = new File(this.settingsFilePath);
    File settingsFile = new File(String.valueOf(this.oldFile.getParent()) + "/settings/scale.pierlu");
    public static Thread thread;
    private boolean running;
    private int FPS = 60;
    private long targetTime = this.FPS / 1000;
    private BufferedImage image;
    private Graphics2D g;
    private GameStateManager gsm;

    public GamePanel() {
        SCALE = this.readScale();
        this.setPreferredSize(new Dimension(512 * SCALE, 256 * SCALE));
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addNotifify();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readScale() {
        int newScale = 1;
        try {
            if (!this.settingsFile.exists()) {
                File dir = new File(String.valueOf(this.oldFile.getParent()) + "/settings");
                if (dir.exists()) {
                    this.settingsFile.createNewFile();
                } else {
                    if (!dir.mkdir()) return newScale;
                    if (!this.settingsFile.createNewFile()) return newScale;
                    FileWriter fw = new FileWriter(this.settingsFile);
                    PrintWriter pw = new PrintWriter(fw);
                    pw.write("");
                    pw.println("1");
                    pw.close();
                }
            }
            BufferedReader br = new BufferedReader(new FileReader(this.settingsFile));
            newScale = Integer.parseInt(br.readLine());
            br.close();
            return newScale;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newScale;
    }

    public void addNotifify() {
        super.addNotify();
        if (thread == null) {
            thread = new Thread(this);
            thread.start();
        }
    }

    private void init() {
        this.image = new BufferedImage(512, 256, 1);
        this.g = (Graphics2D)this.image.getGraphics();
        this.running = true;
        this.gsm = new GameStateManager();
    }

    @Override
    public void run() {
        this.init();
        while (this.running) {
            long start = System.nanoTime();
            this.update();
            this.draw();
            this.drawToScreen();
            long elapsed = System.nanoTime() - start;
            long wait = this.targetTime - elapsed / 1000000L;
            if (wait <= 0L) {
                wait = 5L;
            }
            try {
                Thread.sleep(wait);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void update() {
        this.gsm.update();
    }

    private void draw() {
        this.gsm.draw(this.g);
    }

    private void drawToScreen() {
        Graphics g2 = this.getGraphics();
        g2.drawImage(this.image, 0, 0, 512 * SCALE, 256 * SCALE, null);
        g2.dispose();
    }

    @Override
    public void keyTyped(KeyEvent key) {
    }

    @Override
    public void keyPressed(KeyEvent key) {
        this.gsm.keyPressed(key.getKeyCode());
    }

    @Override
    public void keyReleased(KeyEvent key) {
        this.gsm.keyReleased(key.getKeyCode());
    }

    public static void restart() {
        thread.stop();
    }
}

