/*
 * Decompiled with CFR 0.152.
 */
package main.menuOptions;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFrame;
import javax.swing.JPanel;
import main.Game;
import main.GamePanel;
import main.menuOptions.settingsOptions.ChangeCommands;

public class Settings
extends JPanel
implements KeyListener,
Runnable {
    public static JFrame settingsFrame = new JFrame("Super Pierlu Bros - Settings");
    private static int WIDTH = 1024;
    private static int HEIGHT = 512;
    private Thread thread;
    private boolean running;
    String settingsFilePath = System.getProperty("user.dir");
    File oldFile = new File(this.settingsFilePath);
    File settingsFile = new File(String.valueOf(this.oldFile.getParent()) + "/settings/scale.pierlu");
    public static int backgroundSelection;
    private String[] backgroundOptions = new String[]{"Sea", "Cave"};
    private static int resSelection;
    private String[] resOptions = new String[]{"Piccola", "Grande"};
    private static int currentSelection;
    private String[] settingsOptions = new String[]{"Background:    " + this.backgroundOptions[0] + "  -  " + this.backgroundOptions[1], "Comandi", "Risoluzione:   " + this.resOptions[0] + " - " + this.resOptions[1]};
    private Color fontColor = new Color(0, 0, 0);
    private Font font = new Font("Calibri", 0, 24);

    private void init() {
        this.running = true;
    }

    public Settings() {
        this.addKeyListener(this);
        this.setFocusable(true);
        this.addNotifify();
    }

    public void addNotifify() {
        super.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
    }

    @Override
    public void run() {
        this.init();
        while (this.running) {
            this.repaint();
        }
    }

    public static void main(String[] args) {
        settingsFrame.setSize(WIDTH, HEIGHT);
        settingsFrame.setDefaultCloseOperation(0);
        settingsFrame.setResizable(false);
        settingsFrame.getContentPane().add(new Settings());
        settingsFrame.setVisible(true);
        currentSelection = 0;
        resSelection = GamePanel.SCALE - 1;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.fontColor);
        g.setFont(this.font);
        int i = 0;
        while (i < this.settingsOptions.length) {
            if (i == currentSelection) {
                g.setColor(Color.RED);
            } else {
                g.setColor(this.fontColor);
            }
            g.drawString(this.settingsOptions[i], WIDTH - WIDTH + 10, HEIGHT - HEIGHT + 25 + i * 30);
            ++i;
        }
        if (backgroundSelection == 0) {
            g.setColor(Color.GREEN);
            g.drawString(this.backgroundOptions[backgroundSelection], WIDTH - WIDTH + 10 + 143, HEIGHT - HEIGHT + 25);
        } else if (backgroundSelection == 1) {
            g.setColor(Color.GREEN);
            g.drawString(this.backgroundOptions[backgroundSelection], WIDTH - WIDTH + 10 + backgroundSelection * 205, HEIGHT - HEIGHT + 25);
        }
        if (resSelection == 0) {
            g.setColor(Color.GREEN);
            g.drawString(this.resOptions[0], 144, 85);
        } else if (resSelection == 1) {
            g.setColor(Color.GREEN);
            g.drawString(this.resOptions[1], 230, 85);
        }
        g.setColor(Color.BLACK);
        g.drawString("Per applicare i cambiamenti della risoluzione, bisogna riavviare il gioco", 2, HEIGHT - 50);
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            settingsFrame.setVisible(false);
        }
        if (e.getKeyCode() == 38 && --currentSelection < 0) {
            currentSelection = this.settingsOptions.length - 1;
        }
        if (e.getKeyCode() == 40 && ++currentSelection >= this.settingsOptions.length) {
            currentSelection = 0;
        }
        if (e.getKeyCode() == 37) {
            if (currentSelection == 0) {
                this.selectBackground(1);
            } else if (currentSelection == 2) {
                this.changeRes();
            }
        }
        if (e.getKeyCode() == 39) {
            if (currentSelection == 0) {
                this.selectBackground(2);
            } else if (currentSelection == 2) {
                this.changeRes();
            }
        }
        if (e.getKeyCode() == 10) {
            if (currentSelection == 0) {
                this.selectBackground(0);
            } else if (currentSelection == 1) {
                settingsFrame.setVisible(false);
                ChangeCommands.main(null);
            } else if (currentSelection == 2) {
                this.changeRes();
            }
        }
        if (e.getKeyCode() == 27) {
            currentSelection = 0;
            settingsFrame.setVisible(false);
            Game.window.setEnabled(true);
            Game.window.setVisible(true);
        }
    }

    public void changeRes() {
        if (resSelection == 0) {
            ++resSelection;
        } else if (resSelection == 1) {
            --resSelection;
        }
        try {
            FileWriter fw = new FileWriter(this.settingsFile);
            PrintWriter pw = new PrintWriter(fw);
            pw.write("");
            pw.println("" + (resSelection + 1));
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void selectBackground(int w) {
        if (currentSelection == 0) {
            backgroundSelection = backgroundSelection == 0 ? 1 : (backgroundSelection == 1 ? 0 : 2);
        }
    }
}

