/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.Enemy;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Iceflake
extends Enemy {
    private ArrayList<BufferedImage[]> sprites;
    private final int[] numFrames = new int[]{8, 9, 9, 5, 8};
    private static final int IDLE = 0;
    private static final int JUMPING = 1;
    private static final int JUMPING2 = 2;
    private static final int ATTACKING = 3;
    private static final int DYING = 4;
    private ArrayList<Enemy> enemies;

    public Iceflake(TileMap tm) {
        super(tm);
        this.fallSpeed = 0.05;
        this.maxFallSpeed = 10.0;
        this.width = 32;
        this.height = 32;
        this.cwidth = 15;
        this.cheight = 30;
        this.maxHealth = 1;
        this.health = 1;
        this.damage = 1;
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/iceflake.gif"));
            this.sprites = new ArrayList();
            int i = 0;
            while (i < 5) {
                BufferedImage[] bi = new BufferedImage[this.numFrames[i]];
                int j = 0;
                while (j < this.numFrames[i]) {
                    bi[j] = spritesheet.getSubimage(j * this.width, i * this.height, this.width, this.height);
                    ++j;
                }
                this.sprites.add(bi);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.currentAction = 0;
        this.animation.setFrames(this.sprites.get(0));
        this.animation.setDelay(230L);
    }

    private void getNextPosition() {
        if (this.falling) {
            this.dy += this.fallSpeed;
        }
    }

    public void die() {
        if (this.animation.hasPlayedOnce()) {
            this.currentAction = 4;
            this.animation.setFrames(this.sprites.get(4));
            this.animation.setDelay(100L);
            this.setDyeAnimation(this.sprites.get(4));
        }
    }

    public void attack() {
        if (this.animation.hasPlayedOnce()) {
            this.currentAction = 3;
            this.animation.setFrames(this.sprites.get(3));
            this.animation.setDelay(100L);
            this.setHit(false);
        }
    }

    @Override
    public void update() {
        this.getNextPosition();
        this.checkCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.isIceflakeDead) {
            this.die();
        }
        if (this.getHit()) {
            this.attack();
        }
        if (this.currentAction == 0 && this.animation.hasPlayedOnce()) {
            this.currentAction = 1;
            this.animation.setFrames(this.sprites.get(1));
            this.animation.setDelay(80L);
        }
        if (this.currentAction == 1 && this.animation.hasPlayedOnce()) {
            this.currentAction = 2;
            this.animation.setFrames(this.sprites.get(2));
            this.animation.setDelay(90L);
        }
        if (this.currentAction == 2 && this.animation.hasPlayedOnce()) {
            this.currentAction = 0;
            this.animation.setFrames(this.sprites.get(0));
            this.animation.setDelay(230L);
        }
        if (this.currentAction == 3 && this.animation.hasPlayedOnce()) {
            this.currentAction = 2;
            this.animation.setFrames(this.sprites.get(2));
            this.animation.setDelay(90L);
        }
        this.animation.update();
    }

    public void checkCollision() {
        this.currColumn = (int)this.x / this.tileSize;
        this.currRow = (int)this.y / this.tileSize;
        this.xdest = this.x + this.dx;
        this.ydest = this.y + this.dy;
        this.xtemp = this.x;
        this.ytemp = this.y;
        this.calculateCorners(this.x, this.ydest);
        if (this.dy < 0.0) {
            if (this.topLeft || this.topRight) {
                this.dy = 0.0;
                this.ytemp = this.currRow * this.tileSize + this.cheight / 2;
            } else {
                this.ytemp += this.dy;
            }
        }
        if (this.dy > 0.0) {
            if (this.bottomLeft || this.bottomRight) {
                this.dy = 0.0;
                this.falling = false;
                this.ytemp = (this.currRow + 1) * this.tileSize - this.cheight / 2;
            } else {
                this.ytemp += this.dy;
            }
        }
        this.calculateCorners(this.xdest, this.y);
        if (this.dx < 0.0) {
            if (this.topLeft || this.bottomLeft) {
                this.dx = 0.0;
                this.xtemp = this.currColumn * this.tileSize + this.cwidth / 2;
            } else {
                this.xtemp += this.dx;
            }
        }
        if (this.dx > 0.0) {
            if (this.topRight || this.bottomRight) {
                this.dx = 0.0;
                this.xtemp = (this.currColumn + 1) * this.tileSize - this.cwidth / 2;
            } else {
                this.xtemp += this.dx;
            }
        }
        if (!this.falling) {
            this.calculateCorners(this.x, this.ydest + 1.0);
            if (!this.bottomLeft && !this.bottomRight) {
                this.falling = true;
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        super.draw(g);
    }
}

