/*
 * Decompiled with CFR 0.152.
 */
package Entity.liquids;

import Entity.Animation;
import Entity.Enemy;
import Entity.Player;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.Timer;

public class Acid
extends Enemy {
    private BufferedImage[] sprites;
    private BufferedImage[] water;
    private Timer timer;
    private Timer acidHit;
    private boolean isAcid;
    private int timerCount;
    private Player player;

    public Acid(TileMap tm, int nx, int ny, int imh, Player p) {
        super(tm);
        this.facingRight = true;
        this.player = p;
        this.isAcid = true;
        this.timerCount = 0;
        this.x = nx;
        this.y = imh > 0 ? (double)ny : (double)(ny - imh / 2 + 2);
        this.width = 32;
        this.height = 27 + imh;
        this.cwidth = 32;
        this.cheight = 32;
        this.health = 1000000;
        this.damage = 2;
        try {
            BufferedImage spriteS = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/tiles/acid_static.png"));
            this.sprites = new BufferedImage[31];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spriteS.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
            this.water = new BufferedImage[31];
            i = 0;
            while (i < this.water.length) {
                this.water[i] = spriteS.getSubimage(i * this.width, 32, this.width, this.height);
                ++i;
            }
            this.animation = new Animation();
            this.animation.setFrames(this.sprites);
            this.animation.setDelay(80L);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.timer = new Timer(1, e -> this.timerChanger());
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public void timerChanger() {
        ++this.timerCount;
        if (!this.isAcid) {
            if (this.timerCount > 1000) {
                this.isAcid = true;
                this.changeAcid();
            }
        } else if (this.isAcid && this.timerCount > 4000) {
            this.isAcid = false;
            this.timerCount = 0;
            this.changeAcid();
        }
    }

    public void changeAcid() {
        if (!this.isAcid) {
            this.animation.setFrames(this.water);
        }
        if (this.isAcid) {
            this.animation.setFrames(this.sprites);
        }
        this.animation.setDelay(80L);
    }

    @Override
    public void update() {
        this.setPosition(this.x, this.y);
        this.animation.update();
        if ((double)this.player.getx() > this.x - (double)(this.cwidth / 2) && (double)this.player.getx() < this.x + (double)(this.cwidth / 2) && (double)this.player.gety() > this.y - (double)(this.cheight / 2) && (double)this.player.gety() < this.y + (double)(this.cheight / 2) && this.isAcid) {
            this.player.hit(4);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.setMapPosition();
        super.draw(g);
    }
}

