/*
 * Decompiled with CFR 0.152.
 */
package TileMap;

import TileMap.Tile;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;

public class TileMap {
    private double x;
    private double y;
    private int xmin;
    private int ymin;
    private int xmax;
    private int ymax;
    private double tween;
    private int[][] map;
    private int tileSize;
    private int numRow;
    private int numColumn;
    private int width;
    private int height;
    private BufferedImage tileSet;
    private int numTilesAcross;
    private Tile[][] tiles;
    private int rowOffset;
    private int columnOffset;
    private int numRowDraw;
    private int numColumnDraw;
    private int numColumnItems;
    private int[] GREEN_SIDE_LEFT;
    private int[] GREEN_SIDE_RIGHT;
    private int[] BROWN_SIDE_LEFT;
    private int[] BROWN_SIDE_RIGHT;
    private int[] LEVEL_DOOR;
    private int[] FAKE_BRICKS;
    private int[] FAKE_BROWN;
    private int[] FAKE_GREEN;
    private int[] FAKE_ICE_OR_TOP_BLUE_PORTAL;
    private int[] BOTTOM_BLUE_PORTAL;
    private int[] TOP_ORANGE_PORTAL;
    private int[] BOTTOM_ORANGE_PORTAL;
    private int[] BROWN_SIDE_UP;
    private int[] BROWN_SIDE_UP_RIGHT;
    private int[] BROWN_SIDE_UP_LEFT;
    private int[] BROWN;
    private int[] GREEN;
    private int[] GREEN_ISLAND_LEFT;
    private int[] GREEN_ISLAND_MIDDLE;
    private int[] GREEN_ISALND_RIGHT;
    private int[] BRICKS;
    private int[] TUBE_UP;
    private int[] TUBE_DOWN;
    private int[] ICE;
    private int[] ICE_SLIDE;
    private int[] COIN;
    private int[] SLUGGER;
    private int[] BROCKY;
    private int[] CARROT;
    private int[] ICEFLAKE;

    public TileMap(int tileSize) {
        int[] nArray = new int[4];
        nArray[0] = 150;
        nArray[2] = 60;
        nArray[3] = 10;
        this.GREEN_SIDE_LEFT = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 150;
        nArray2[2] = 40;
        nArray2[3] = 10;
        this.GREEN_SIDE_RIGHT = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 150;
        nArray3[1] = 50;
        nArray3[2] = 20;
        this.BROWN_SIDE_LEFT = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 150;
        nArray4[1] = 30;
        nArray4[2] = 20;
        this.BROWN_SIDE_RIGHT = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 255;
        this.LEVEL_DOOR = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 200;
        nArray6[1] = 255;
        nArray6[2] = 30;
        this.FAKE_BRICKS = nArray6;
        int[] nArray7 = new int[4];
        nArray7[0] = 200;
        nArray7[1] = 70;
        nArray7[2] = 20;
        this.FAKE_BROWN = nArray7;
        int[] nArray8 = new int[4];
        nArray8[0] = 200;
        nArray8[2] = 120;
        nArray8[3] = 20;
        this.FAKE_GREEN = nArray8;
        int[] nArray9 = new int[4];
        nArray9[0] = 200;
        nArray9[2] = 255;
        nArray9[3] = 255;
        this.FAKE_ICE_OR_TOP_BLUE_PORTAL = nArray9;
        int[] nArray10 = new int[4];
        nArray10[0] = 255;
        nArray10[2] = 120;
        nArray10[3] = 255;
        this.BOTTOM_BLUE_PORTAL = nArray10;
        int[] nArray11 = new int[4];
        nArray11[0] = 255;
        nArray11[1] = 255;
        nArray11[2] = 170;
        this.TOP_ORANGE_PORTAL = nArray11;
        int[] nArray12 = new int[4];
        nArray12[0] = 255;
        nArray12[1] = 255;
        nArray12[2] = 150;
        this.BOTTOM_ORANGE_PORTAL = nArray12;
        int[] nArray13 = new int[4];
        nArray13[0] = 100;
        nArray13[1] = 70;
        nArray13[2] = 20;
        this.BROWN_SIDE_UP = nArray13;
        int[] nArray14 = new int[4];
        nArray14[0] = 120;
        nArray14[1] = 70;
        nArray14[2] = 10;
        this.BROWN_SIDE_UP_RIGHT = nArray14;
        int[] nArray15 = new int[4];
        nArray15[0] = 120;
        nArray15[1] = 70;
        nArray15[2] = 30;
        this.BROWN_SIDE_UP_LEFT = nArray15;
        int[] nArray16 = new int[4];
        nArray16[0] = 255;
        nArray16[1] = 70;
        nArray16[2] = 20;
        this.BROWN = nArray16;
        int[] nArray17 = new int[4];
        nArray17[0] = 255;
        nArray17[2] = 120;
        nArray17[3] = 20;
        this.GREEN = nArray17;
        int[] nArray18 = new int[4];
        nArray18[0] = 200;
        nArray18[2] = 120;
        nArray18[3] = 10;
        this.GREEN_ISLAND_LEFT = nArray18;
        int[] nArray19 = new int[4];
        nArray19[0] = 200;
        nArray19[2] = 120;
        nArray19[3] = 20;
        this.GREEN_ISLAND_MIDDLE = nArray19;
        int[] nArray20 = new int[4];
        nArray20[0] = 200;
        nArray20[2] = 120;
        nArray20[3] = 30;
        this.GREEN_ISALND_RIGHT = nArray20;
        int[] nArray21 = new int[4];
        nArray21[0] = 255;
        nArray21[1] = 255;
        nArray21[2] = 30;
        this.BRICKS = nArray21;
        this.TUBE_UP = new int[]{255, 127, 127, 127};
        this.TUBE_DOWN = new int[]{200, 127, 127, 127};
        int[] nArray22 = new int[4];
        nArray22[0] = 255;
        nArray22[2] = 255;
        nArray22[3] = 255;
        this.ICE = nArray22;
        int[] nArray23 = new int[4];
        nArray23[0] = 125;
        nArray23[2] = 255;
        nArray23[3] = 255;
        this.ICE_SLIDE = nArray23;
        int[] nArray24 = new int[4];
        nArray24[0] = 255;
        nArray24[1] = 255;
        nArray24[2] = 238;
        this.COIN = nArray24;
        int[] nArray25 = new int[4];
        nArray25[0] = 225;
        nArray25[1] = 195;
        nArray25[3] = 255;
        this.SLUGGER = nArray25;
        int[] nArray26 = new int[4];
        nArray26[0] = 225;
        nArray26[1] = 3;
        nArray26[2] = 204;
        this.BROCKY = nArray26;
        int[] nArray27 = new int[4];
        nArray27[0] = 225;
        nArray27[1] = 204;
        nArray27[2] = 112;
        this.CARROT = nArray27;
        this.ICEFLAKE = new int[]{225, 204, 204, 204};
        this.tileSize = tileSize;
        this.numRowDraw = 256 / tileSize + 2;
        this.numColumnDraw = 512 / tileSize + 2;
        this.tween = 0.07;
    }

    public void loadTilesPaint(String s) {
        try {
            this.tileSet = ImageIO.read(this.getClass().getResourceAsStream(s));
            this.numTilesAcross = this.tileSet.getWidth() / this.tileSize;
            this.tiles = new Tile[3][this.numTilesAcross];
            int col = 0;
            while (col < this.numTilesAcross) {
                BufferedImage subImage = this.tileSet.getSubimage(col * this.tileSize, 0, this.tileSize, this.tileSize);
                this.tiles[0][col] = new Tile(subImage, 0);
                subImage = this.tileSet.getSubimage(col * this.tileSize, this.tileSize, this.tileSize, this.tileSize);
                this.tiles[1][col] = new Tile(subImage, 1);
                ++col;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadTiles(String s) {
        try {
            this.tileSet = ImageIO.read(this.getClass().getResourceAsStream(s));
            this.numTilesAcross = this.tileSet.getWidth() / this.tileSize;
            this.tiles = new Tile[3][this.numTilesAcross];
            int col = 0;
            while (col < this.numTilesAcross) {
                BufferedImage subImage = this.tileSet.getSubimage(col * this.tileSize, 0, this.tileSize, this.tileSize);
                this.tiles[0][col] = new Tile(subImage, 0);
                subImage = this.tileSet.getSubimage(col * this.tileSize, this.tileSize, this.tileSize, this.tileSize);
                this.tiles[1][col] = new Tile(subImage, 1);
                ++col;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadMapP(String s) {
        try {
            BufferedImage bi = ImageIO.read(this.getClass().getResourceAsStream(s));
            this.numRow = bi.getHeight();
            this.numColumn = bi.getWidth();
            System.out.println(String.valueOf(this.numColumn) + " - " + this.numRow);
            this.map = new int[this.numRow][this.numColumn];
            this.width = this.numColumn * this.tileSize;
            this.height = this.numRow * this.tileSize;
            this.xmin = 512 - this.width;
            this.xmax = 0;
            this.ymin = 256 - this.height;
            this.ymax = 0;
            int row = 0;
            while (row < this.numRow) {
                int col = 0;
                while (col < this.numColumn) {
                    this.map[row][col] = this.checkColor(col, row, this.width, this.height, bi);
                    ++col;
                }
                ++row;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDeathY() {
        return this.height - 17;
    }

    public int checkColor(int x, int y, int w, int h, BufferedImage image) {
        int blue;
        int green;
        int red;
        int tileID = 0;
        int pixel = image.getRGB(x, y);
        int alpha = pixel >> 24 & 0xFF;
        int[] color = new int[]{alpha, red = pixel >> 16 & 0xFF, green = pixel >> 8 & 0xFF, blue = pixel & 0xFF};
        if (color[0] == 0 && color[1] == 0 && color[2] == 0 && color[3] == 0) {
            tileID = 0;
        }
        if (color[0] == this.GREEN_SIDE_LEFT[0] && color[1] == this.GREEN_SIDE_LEFT[1] && color[2] == this.GREEN_SIDE_LEFT[2] && color[3] == this.GREEN_SIDE_LEFT[3]) {
            tileID = 1;
        }
        if (color[0] == this.GREEN_SIDE_RIGHT[0] && color[1] == this.GREEN_SIDE_RIGHT[1] && color[2] == this.GREEN_SIDE_RIGHT[2] && color[3] == this.GREEN_SIDE_RIGHT[3]) {
            tileID = 2;
        }
        if (color[0] == this.BROWN_SIDE_LEFT[0] && color[1] == this.BROWN_SIDE_LEFT[1] && color[2] == this.BROWN_SIDE_LEFT[2] && color[3] == this.BROWN_SIDE_LEFT[3]) {
            tileID = 3;
        }
        if (color[0] == this.BROWN_SIDE_RIGHT[0] && color[1] == this.BROWN_SIDE_RIGHT[1] && color[2] == this.BROWN_SIDE_RIGHT[2] && color[3] == this.BROWN_SIDE_RIGHT[3]) {
            tileID = 4;
        }
        if (color[0] == this.LEVEL_DOOR[0] && color[1] == this.LEVEL_DOOR[1] && color[2] == this.LEVEL_DOOR[2] && color[3] == this.LEVEL_DOOR[3]) {
            tileID = 5;
        }
        if (color[0] == this.FAKE_BRICKS[0] && color[1] == this.FAKE_BRICKS[1] && color[2] == this.FAKE_BRICKS[2] && color[3] == this.FAKE_BRICKS[3]) {
            tileID = 6;
        }
        if (color[0] == this.FAKE_BROWN[0] && color[1] == this.FAKE_BROWN[1] && color[2] == this.FAKE_BROWN[2] && color[3] == this.FAKE_BROWN[3]) {
            tileID = 9;
        }
        if (color[0] == this.FAKE_GREEN[0] && color[1] == this.FAKE_GREEN[1] && color[2] == this.FAKE_GREEN[2] && color[3] == this.FAKE_GREEN[3]) {
            tileID = 10;
        }
        if (color[0] == this.FAKE_ICE_OR_TOP_BLUE_PORTAL[0] && color[1] == this.FAKE_ICE_OR_TOP_BLUE_PORTAL[1] && color[2] == this.FAKE_ICE_OR_TOP_BLUE_PORTAL[2] && color[3] == this.FAKE_ICE_OR_TOP_BLUE_PORTAL[3]) {
            tileID = 11;
        }
        if (color[0] == this.BOTTOM_BLUE_PORTAL[0] && color[1] == this.BOTTOM_BLUE_PORTAL[1] && color[2] == this.BOTTOM_BLUE_PORTAL[2] && color[3] == this.BOTTOM_BLUE_PORTAL[3]) {
            tileID = 12;
        }
        if (color[0] == this.TOP_ORANGE_PORTAL[0] && color[1] == this.TOP_ORANGE_PORTAL[1] && color[2] == this.TOP_ORANGE_PORTAL[2] && color[3] == this.TOP_ORANGE_PORTAL[3]) {
            tileID = 13;
        }
        if (color[0] == this.BOTTOM_ORANGE_PORTAL[0] && color[1] == this.BOTTOM_ORANGE_PORTAL[1] && color[2] == this.BOTTOM_ORANGE_PORTAL[2] && color[3] == this.BOTTOM_ORANGE_PORTAL[3]) {
            tileID = 14;
        }
        if (color[0] == this.BROWN_SIDE_UP[0] && color[1] == this.BROWN_SIDE_UP[1] && color[2] == this.BROWN_SIDE_UP[2] && color[3] == this.BROWN_SIDE_UP[3]) {
            tileID = 17;
        }
        if (color[0] == this.BROWN_SIDE_UP_RIGHT[0] && color[1] == this.BROWN_SIDE_UP_RIGHT[1] && color[2] == this.BROWN_SIDE_UP_RIGHT[2] && color[3] == this.BROWN_SIDE_UP_RIGHT[3]) {
            tileID = 18;
        }
        if (color[0] == this.BROWN_SIDE_UP_LEFT[0] && color[1] == this.BROWN_SIDE_UP_LEFT[1] && color[2] == this.BROWN_SIDE_UP_LEFT[2] && color[3] == this.BROWN_SIDE_UP_LEFT[3]) {
            tileID = 19;
        }
        if (color[0] == this.GREEN[0] && color[1] == this.GREEN[1] && color[2] == this.GREEN[2] && color[3] == this.GREEN[3]) {
            tileID = 21;
        }
        if (color[0] == this.BROWN[0] && color[1] == this.BROWN[1] && color[2] == this.BROWN[2] && color[3] == this.BROWN[3]) {
            tileID = 22;
        }
        if (color[0] == this.GREEN_ISLAND_LEFT[0] && color[1] == this.GREEN_ISLAND_LEFT[1] && color[2] == this.GREEN_ISLAND_LEFT[2] && color[3] == this.GREEN_ISLAND_LEFT[3]) {
            tileID = 23;
        }
        if (color[0] == this.GREEN_ISLAND_MIDDLE[0] && color[1] == this.GREEN_ISLAND_MIDDLE[1] && color[2] == this.GREEN_ISLAND_MIDDLE[2] && color[3] == this.GREEN_ISLAND_MIDDLE[3]) {
            tileID = 24;
        }
        if (color[0] == this.GREEN_ISALND_RIGHT[0] && color[1] == this.GREEN_ISALND_RIGHT[1] && color[2] == this.GREEN_ISALND_RIGHT[2] && color[3] == this.GREEN_ISALND_RIGHT[3]) {
            tileID = 25;
        }
        if (color[0] == this.BRICKS[0] && color[1] == this.BRICKS[1] && color[2] == this.BRICKS[2] && color[3] == this.BRICKS[3]) {
            tileID = 26;
        }
        if (color[0] == this.TUBE_UP[0] && color[1] == this.TUBE_UP[1] && color[2] == this.TUBE_UP[2] && color[3] == this.TUBE_UP[3]) {
            tileID = 27;
        }
        if (color[0] == this.TUBE_DOWN[0] && color[1] == this.TUBE_DOWN[1] && color[2] == this.TUBE_DOWN[2] && color[3] == this.TUBE_DOWN[3]) {
            tileID = 28;
        }
        if (color[0] == this.ICE[0] && color[1] == this.ICE[1] && color[2] == this.ICE[2] && color[3] == this.ICE[3]) {
            tileID = 29;
        }
        if (color[0] == this.ICE_SLIDE[0] && color[1] == this.ICE_SLIDE[1] && color[2] == this.ICE_SLIDE[2] && color[3] == this.ICE_SLIDE[3]) {
            tileID = 30;
        }
        if (color[0] == this.COIN[0] && color[1] == this.COIN[1] && color[2] == this.COIN[2] && color[3] == this.COIN[3]) {
            tileID = 60;
        }
        if (color[0] == this.SLUGGER[0] && color[1] == this.SLUGGER[1] && color[2] == this.SLUGGER[2] && color[3] == this.SLUGGER[3]) {
            tileID = 61;
        }
        if (color[0] == this.BROCKY[0] && color[1] == this.BROCKY[1] && color[2] == this.BROCKY[2] && color[3] == this.BROCKY[3]) {
            tileID = 62;
        }
        if (color[0] == this.CARROT[0] && color[1] == this.CARROT[1] && color[2] == this.CARROT[2] && color[3] == this.CARROT[3]) {
            tileID = 63;
        }
        if (color[0] == this.ICEFLAKE[0] && color[1] == this.ICEFLAKE[1] && color[2] == this.ICEFLAKE[2] && color[3] == this.ICEFLAKE[3]) {
            tileID = 64;
        }
        return tileID;
    }

    public void loadMap(String s) {
        try {
            InputStream in = this.getClass().getResourceAsStream(s);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            this.numColumn = Integer.parseInt(br.readLine());
            this.numRow = Integer.parseInt(br.readLine());
            this.map = new int[this.numRow][this.numColumn];
            this.width = this.numColumn * this.tileSize;
            this.height = this.numRow * this.tileSize;
            this.xmin = 512 - this.width;
            this.xmax = 0;
            this.ymin = 256 - this.height;
            this.ymax = 0;
            String delims = "\\s+";
            int row = 0;
            while (row < this.numRow) {
                String line = br.readLine();
                String[] tokens = line.split(delims);
                int col = 0;
                while (col < this.numColumn) {
                    this.map[row][col] = Integer.parseInt(tokens[col]);
                    ++col;
                }
                ++row;
            }
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getx() {
        return (int)this.x;
    }

    public int gety() {
        return (int)this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getType(int row, int col) {
        int rc = this.map[row][col];
        int r = rc / this.numTilesAcross;
        int c = rc % this.numTilesAcross;
        return this.tiles[r][c].getType();
    }

    public void setPosition(double x, double y) {
        this.x += (x - this.x) * this.tween;
        this.y += (y - this.y) * this.tween;
        this.fixBounds();
        this.columnOffset = (int)(-this.x) / this.tileSize;
        this.rowOffset = (int)(-this.y) / this.tileSize;
    }

    public void fixBounds() {
        if (this.x < (double)this.xmin) {
            this.x = this.xmin;
        }
        if (this.y < (double)this.ymin) {
            this.y = this.ymin;
        }
        if (this.x > (double)this.xmax) {
            this.x = this.xmax;
        }
        if (this.y > (double)this.ymax) {
            this.y = this.ymax;
        }
    }

    public void draw(Graphics2D g) {
        int row = this.rowOffset;
        while (row < this.rowOffset + this.numRowDraw) {
            if (row >= this.numRow) break;
            int col = this.columnOffset;
            while (col < this.columnOffset + this.numColumnDraw) {
                if (col >= this.numColumn) break;
                if (this.map[row][col] != 0) {
                    int rc = this.map[row][col];
                    int r = rc / this.numTilesAcross;
                    int c = rc % this.numTilesAcross;
                    g.drawImage((Image)this.tiles[r][c].getImage(), (int)this.x + col * this.tileSize, (int)this.y + row * this.tileSize, null);
                }
                ++col;
            }
            ++row;
        }
    }
}

